
/* 
       3-VOICE ARDUINO SYNTHESIZER
      
      3 squarewave tones produced from Arduino pins 
      
      Slider1 - Sets Frequency of Tone1 with arduino tone()
      Slider2 - Sets Frequency of Tone2
      Slider3 - Sets Frequency of Tone3 
      Slider4 - Sets the decrement clock

      Switch1 - turns off or on Tone2
      Switch2 - turns off or on Tone3 

Arduino's tone() function can only be used to set up a squarewave on one output.
Two more voices are created from a fast loop clock decrementing two freq values and toggling voice outputs
when they reach zero.  The freq values determine the frequency of the voices.

      
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Pro Micro.  

// 
// ANALOG INPUTS
//
const int POT1 = A0;  //Potentiometer pin numbers
const int POT2 = A1;
const int POT3 = A2;
const int POT4 = A3;
const int POT5 = A7;

int pot1 = 0;
int pot2 = 0;
int pot3 = 0;
int pot4 = 0;
int pot5 = 0;

//
//DIGIITAL SWITCHES
//  
const int S1 = 7;  //Switch pin numbers
const int S2 = 8;
const int S3 = 16;
const int S4 = 14;

boolean switch1 = 0;
boolean switch2 = 0;
boolean pushbutton1 = 0;
boolean pushbutton2 = 0;

//
// SYTHESIZER CONSTANTS
//

const int VOICEA = 5;  //Voice pin numbers
const int VOICEB = 4;
const int VOICEC = 2;
const int VOICED = 3;


const int LED1 = 9;  //Led pin numbers
const int LED2 = 10;

int freq2 = 100;  //variables to set voice frequencies
int freq3 = 100;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);
  
pinMode(LED1, OUTPUT);    //turn on LED1 as power indicator
digitalWrite(LED1, HIGH);

pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEA, OUTPUT);    //Lows enable distortion gate
digitalWrite(VOICEA, LOW);
pinMode(VOICEB, OUTPUT);
digitalWrite(VOICEB, LOW);
pinMode(VOICEC, OUTPUT);   
digitalWrite(VOICEC, LOW);
pinMode(VOICED, OUTPUT);
digitalWrite(VOICED, HIGH);  //Set simple offset for Distortion Input
                             //Turn down when not using 

pinMode(S1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(S1, HIGH);
pinMode(S2, INPUT);
digitalWrite(S2, HIGH);
pinMode(S3, INPUT);
digitalWrite(S3, HIGH);
pinMode(S4, INPUT);
digitalWrite(S4, HIGH);
                     
 Serial.begin(9600);

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {
                                         
    tone(VOICEA, (analogRead(POT1) << 2));  // set frequency of Voice1 using tone( )
    
    delayMicroseconds(analogRead(POT4) << 4);  // wait before continuing, sets main loop clock

    freq2 = voiceRun(digitalRead(S1), VOICEC, freq2, POT2);  // Voice2                                                 

    freq3 = voiceRun(digitalRead(S2), VOICEB, freq3, POT3);  // Voice3
     
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                    END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


 int voiceRun(bool off_on, int voicePin, int freq, int potPin){
  
   if (off_on) { digitalWrite(voicePin, LOW); }
   
            else{
              --freq;
              if (freq <= 0){
                  digitalWrite(voicePin, !digitalRead(voicePin));
                  freq = analogRead(potPin) >> 4;
              }
            }
  return freq;       
  } 

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
