
/* 
      Arduino Distortion Unit
      MIDI Program
      Uses MIDIUSB.h library to run MIDI commands over the USB cable
      Works with all Arduinos that have the ATmega32U4 processor.  
      These have HID capabilities.
      

      
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Pro Micro.  

#include "MIDIUSB.h"

// 
// ANALOG INPUTS
//
const int POT1 = A0;  //Potentiometer pin numbers
const int POT2 = A1;
const int POT3 = A2;
const int POT4 = A3;
const int POT5 = A7;

int pot1 = 0;
int pot2 = 0;
int pot3 = 0;
int pot4 = 0;
int pot5 = 0;

//
//DIGIITAL SWITCHES
//  
const int S1 = 7;  //Switch pin numbers
const int S2 = 8;
const int S3 = 16;
const int S4 = 14;

boolean switch1 = 0;
boolean switch2 = 0;
boolean pushbutton1 = 0;
boolean pushbutton2 = 0;

//
// SYTHESIZER CONSTANTS
//

const int VOICEA = 5;  //Voice pin numbers
const int VOICEB = 4;
const int VOICEC = 2;
const int VOICED = 3;


const int LED1 = 9;  //Led pin numbers
const int LED2 = 10;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);
tone(VOICEB, 64, 1000);
delay(2000);
tone(VOICEB, 164, 1000);
  
pinMode(LED1, OUTPUT);    //turn on LED1 as power indicator
digitalWrite(LED1, HIGH);

pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEA, OUTPUT);    //Lows enable distortion gates
digitalWrite(VOICEA, LOW);
pinMode(VOICEB, OUTPUT);
digitalWrite(VOICEB, LOW);
pinMode(VOICEC, OUTPUT);  
digitalWrite(VOICEC, LOW);
pinMode(VOICED, OUTPUT);  
digitalWrite(VOICED, LOW);                               

pinMode(S1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(S1, HIGH);
pinMode(S2, INPUT);
digitalWrite(S2, HIGH);
pinMode(S3, INPUT);
digitalWrite(S3, HIGH);
pinMode(S4, INPUT);
digitalWrite(S4, HIGH);
                     

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

 
midiEventPacket_t rx = MidiUSB.read();

  switch (rx.header) {
    
    case 0:
                break; //No pending events
      
    case 0x9:  //NoteOn
    
              if (rx.byte3 != 0){       //velocity non zero = note on
                tone(VOICEB, rx.byte2 << 4);
                digitalWrite(LED2, HIGH);
              }
              
              else {                   //velocity zero = note off
                noTone(VOICEB);
                digitalWrite(LED2, LOW);
              }
              
                break;
      
    case 0x8: // Note Off
    
                noTone(VOICEB);
                digitalWrite(LED2, LOW);
                break;
                
    case 0xB:  // control Change     
                break;
      
    default:
                 break;
      
  }
  
 
} 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loadSensors(){      // load all current sensor values
      pot1 =   analogRead(POT1);
      pot2 =   analogRead(POT2);
      pot3 =   analogRead(POT3);
      pot4 =   analogRead(POT4);
      pot5 =   analogRead(POT5);    
      switch1 = digitalRead(S1);
      switch2 = digitalRead(S2);
      pushbutton1 = digitalRead(S3);
      pushbutton2 = digitalRead(S4);
}

void noteOn(byte channel, byte pitch, byte velocity) {
  midiEventPacket_t noteOn = {0x09, 0x90 | channel, pitch, velocity};
  MidiUSB.sendMIDI(noteOn);
}

void noteOff(byte channel, byte pitch, byte velocity) {
  midiEventPacket_t noteOff = {0x08, 0x80 | channel, pitch, velocity};
  MidiUSB.sendMIDI(noteOff);
}

void controlChange(byte channel, byte control, byte value) {
  midiEventPacket_t event = {0x0B, 0xB0 | channel, control, value};
  MidiUSB.sendMIDI(event);
}


 
