
/* 
      Arduino Distortion Unit
      Test Program
      Continuously print out the values from the 5 pots and 4 switches.
      

      
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Pro Micro.  


// 
// ANALOG INPUTS
//
const int POT1 = A0;  //Potentiometer pin numbers
const int POT2 = A1;
const int POT3 = A2;
const int POT4 = A3;
const int POT5 = A7;

int pot1 = 0;
int pot2 = 0;
int pot3 = 0;
int pot4 = 0;
int pot5 = 0;

//
//DIGIITAL SWITCHES
//  
const int S1 = 7;  //Switch pin numbers
const int S2 = 8;
const int S3 = 16;
const int S4 = 14;

boolean switch1 = 0;
boolean switch2 = 0;
boolean pushbutton1 = 0;
boolean pushbutton2 = 0;

//
// SYTHESIZER CONSTANTS
//

const int VOICEA = 5;  //Voice pin numbers
const int VOICEB = 4;
const int VOICEC = 2;
const int VOICED = 3;


const int LED1 = 9;  //Led pin numbers
const int LED2 = 10;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);
  
pinMode(LED1, OUTPUT);    //turn on LED1 as power indicator
digitalWrite(LED1, HIGH);

pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEA, OUTPUT);    //Lows enable distortion gates
digitalWrite(VOICEA, LOW);
pinMode(VOICEB, OUTPUT);
digitalWrite(VOICEB, LOW);
pinMode(VOICEC, OUTPUT);  
digitalWrite(VOICEC, LOW);
pinMode(VOICED, OUTPUT);  
digitalWrite(VOICED, HIGH);  //Set simple offset for Distortion Input
                             //Turn down when not using 

pinMode(S1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(S1, HIGH);
pinMode(S2, INPUT);
digitalWrite(S2, HIGH);
pinMode(S3, INPUT);
digitalWrite(S3, HIGH);
pinMode(S4, INPUT);
digitalWrite(S4, HIGH);
                     
 Serial.begin(9600);

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {
 
  loadSensors();
  
   Serial.print("pot1 = ");
  Serial.print(pot1);
    Serial.print("  pot2 = ");
  Serial.print(pot2);
    Serial.print("   pot3 = ");
  Serial.print(pot3);
    Serial.print("   pot4 = ");
  Serial.print(pot4);
    Serial.print("   pot5 = ");
  Serial.print(pot5);
  
     Serial.print("     ");

    Serial.print("  switches ");
  Serial.print(switch1);
  Serial.print(switch2);
  Serial.print(pushbutton1);
  Serial.println(pushbutton2);

// ~~~~~~~~~~~~~~~~~Voice Tests ~~~~~~~~~~~~~~~~~~~~~~~~~

  tone(VOICEA, (100 + pot1));  // Voice A frequency put on pot 1

int v = map(pot2, 0, 255, 1, 40);  // Voice B frequency put on pot 2
  digitalWrite(VOICEB, HIGH);
  delay(v);
  digitalWrite(VOICEB, LOW);
  delay(v);

} 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loadSensors(){      // load all current sensor values
      pot1 =   analogRead(POT1);
      pot2 =   analogRead(POT2);
      pot3 =   analogRead(POT3);
      pot4 =   analogRead(POT4);
      pot5 =   analogRead(POT5);    
      switch1 = digitalRead(S1);
      switch2 = digitalRead(S2);
      pushbutton1 = digitalRead(S3);
      pushbutton2 = digitalRead(S4);
}
 
