
/* 
       3-VOICE ARDUINO SYNTHESIZER
      
      3 squarewave tones randomly produced from Arduino pins.
      
      Pot1 - Sets base Frequency of Voice B
      Pot2 - Sets Frequency Range of Voice B
      Pot3 - Sets base Frequency of Voice C 
      Pot4 - Sets Frequency Range of Voice C

      Switch1 - Selects between Pot5 setting the frequency of Voice A
                or setting overall note durations
      Switch2 - Stops everything at current sounding voices

Arduino's tone() function can only be used to set up a squarewave on one output.
Two more voices are created from the fast loop clock decrementing two freq values and toggling voice outputs
when they reach zero.  The freq values determine the frequency of the voices.

      
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Pro Micro.  

// 
// ANALOG INPUTS
//
const int POT1 = A0;  //Potentiometer pin numbers
const int POT2 = A1;
const int POT3 = A2;
const int POT4 = A3;
const int POT5 = A7;

int pot1 = 0;
int pot2 = 0;
int pot3 = 0;
int pot4 = 0;
int pot5 = 0;

//
//DIGIITAL SWITCHES
//  
const int S1 = 7;  //Switch pin numbers
const int S2 = 8;
const int S3 = 16;
const int S4 = 14;

boolean switch1 = 0;
boolean switch2 = 0;
boolean pushbutton1 = 0;
boolean pushbutton2 = 0;


//
// SYTHESIZER CONSTANTS
//

const int VOICEA = 5;  //Voice pin numbers
const int VOICEB = 4;
const int VOICEC = 2;
const int VOICED = 3;


const int LED1 = 9;  //Led pin numbers
const int LED2 = 10;

int freqA = 100;  //variables to set voice frequencies
int freqB = 100;
int freqC = 100;
int freqD = 100;

int countA = 100;
int countB = 100;
int countC = 100;
int countD = 100;

long A_on =0;
long B_on =0;
long C_on =0;
long D_on =0;

long A_off = 100;
long B_off = 100;
long C_off = 100;
long D_off = 100;

long dur = 100;
bool stopV = 0;



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);
  
pinMode(LED1, OUTPUT);    //turn on LED1 as power indicator
digitalWrite(LED1, HIGH);

pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEA, OUTPUT);    //Lows enable distortion gate
digitalWrite(VOICEA, LOW);
pinMode(VOICEB, OUTPUT);
digitalWrite(VOICEB, LOW);
pinMode(VOICEC, OUTPUT);   
digitalWrite(VOICEC, LOW);
pinMode(VOICED, OUTPUT);
digitalWrite(VOICED, LOW);  

pinMode(1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(S1, HIGH);
pinMode(S2, INPUT);
digitalWrite(S2, HIGH);
pinMode(S3, INPUT);
digitalWrite(S3, HIGH);
pinMode(S4, INPUT);
digitalWrite(S4, HIGH);

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     VOICE A
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

if (digitalRead(S1)){                        // divide up use of pot5 with Switch1
    dur = analogRead(POT5) >> 3;             //set envelope durations 
}
          else{                                    
          tone(VOICEA, (50 + analogRead(POT5)));  // set frequency of VoiceA using tone
          }                                     

 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      VOICE B
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

if (B_on != 0){                                // if Voice is on, sounding 
    if (stopV) {--B_on ;}
    
     --countB;                       // run the voice frequency toggling routine
    if (countB <= 0){
                      digitalWrite(VOICEB, !digitalRead(VOICEB));
                      countB = freqB;
    }
    
              if (B_on == 0){                  // turn off voice if at end of on-duration
                digitalWrite(VOICEB, LOW);
                B_off = random(1, dur) << 4 ;  // get random 8 bit duration for B off time
                freqB = getFreqB();            // get new random frequency for voice
              }   
}

// ------------ 

else if (B_off != 0){                          // if Voice is off, not sounding 
     --B_off;
              if (B_off == 0){                 // turn on voice if at end of off-duration
                 B_on = random(1, dur) << 4 ;  // get random duration for on time 
              }
}
                 

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      VOICE C
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

if (C_on != 0){                                // if Voice is on, sounding 
    if (stopV){--C_on ;}
    
    --countC;                       // run the voice frequency toggling routine
    if (countC <= 0){
                      digitalWrite(VOICEC, !digitalRead(VOICEC));
                      countC = freqC;
    }
    
              if (C_on == 0){                  // turn off voice if at end of on-duration
                digitalWrite(VOICEC, LOW);
                C_off = random(1, dur) << 4 ;  // get random 8 bit duration for B off time
                freqC = getFreqC();            // get new random frequency for voice
              }   
}

// ------------ 

else if (C_off != 0){                          // if Voice is off, not sounding 
     --C_off;
              if (C_off == 0){                 // turn on voice if at end of off-duration
                 C_on = random(1, dur) << 4 ;  // get random duration for on time 
              }
}

    
// ------------Switch2  stops everything to sounding notes---------------------    
    
                             stopV = digitalRead(S3);
                            
} 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


int getFreqB() {   // getting random frequency for Voices
        
    int basefreq = analogRead(POT3) >> 4;
    int result = basefreq + random(analogRead(POT4) >> 3); // range of frequencies around the base
    return result;
}

int getFreqC() {   // getting random frequency for Voices
        
    int basefreq = analogRead(POT1) >> 4;
    int result = basefreq + random(analogRead(POT2) >> 3); // range of frequencies around the base
    return result;
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
