
/* 
                       Random pitches and durations in the 3 AY voices
                       controlled by the 6 sliders

                       Modulated sounds from the SID chip.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~                          

                 Switch1 - Added Noise to VoiceA
                 Switch2 - Stop and slow down.

                 Sliders 1-3 ->  Base Frequency, Voices A-C
                 Sliders 4-6 ->  Frequency Range, Voices A-C 
                 FrontPanelPot -> Note Duration/Speed
                 
                 SoftPot ->  Gates on/off SID voices 1 & 3.  Sets frequency of SID voice 3
                 LightSensor4 -> Frequency of SID voice 1
                 Switch4  ->  Sets SID Modulation between voices 1 & 3.  Ring Mod or SYNC
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
//-------------------------------------------------------
//                      CONSTANTS and Variables
//-------------------------------------------------------

#include <MIDI.h>  // version 4.x.x
MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI); 

// User created MIDI Callback functions here

 const int  MIDI_TX = 18;  //on SERIAL1
 const int MIDI_RX = 19;  //on SERIAL1
// 
// ANALOG INPUTS
//
const int Slider1 = 0;
const int Slider2 = 1;
const int Slider3 = 2;
const int Slider4 = 3;
const int Slider5 = 4;
const int Slider6 = 5;
const int SoftPot = 6;
const int FrontPot = 7;
const int LightSensor1 = 8;
const int LightSensor2 = 9;
const int LightSensor3 = 10;
const int LightSensor4 = 11;
const int LightSensor5 = 12;
const int LightSensor6 = 13;

int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;
int slider5 = 0;
int slider6 = 0;
int softPot = 0;
int frontPot = 0;
int lightSensor1 = 0;
int lightSensor2 = 0;
int lightSensor3 = 0;
int lightSensor4 = 0;
int lightSensor5 = 0;
int lightSensor6 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 14;
const int Switch2 = 15;
const int Switch3 = 16;
const int Switch4 = 17;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

//
// AY SYTHESIZER CONSTANTS
//
const int AYBDIR = 2;  // set up names for some Arduino pins
const int AYBC1 = 4;
const int AYBC2 = 3;

const int AYFineTuneA = 0;  // AY Synth Control Registers
const int AYFineTuneB = 2;
const int AYFineTuneC = 4;
const int AYCourseTuneA = 1;
const int AYCourseTuneB = 3;
const int AYCourseTuneC = 5;
const int AYNoisePeriod = 6;
const int AYEnable = 7;
const int AYAmpA = 8;
const int AYAmpB = 9;
const int AYAmpC = 10;
const int AYEnvFineTune = 11;
const int AYEnvCourseTune = 12;
const int AYEnvShape = 13;

const int VoiceD1 = 7;
const int VoiceD2 = 8;
const int VoiceD3 = 9;

//
//SID SYNTHESIZER CONSTANTS
//
const int SIDCS = 5;
const int SIDRW = 6;

//SID read register values

int potX = 0;
int potY = 0;
int osc3_rand = 0;
int env3 = 0;

int addr[4] = {0, 0, 7, 14};  //voice register address offsets 1, 2, 3
int v = 0;

// voice register values (Use voice = 1, 2, or 3.  Don't use zero)

int Attack[4] = {0, 0, 0, 0};      // (0 to 15)
int Decay[4] = {0, 0, 0, 0};       // (0 to 15)
int Sustainx[4] = {0, 15, 15, 15};  // (0 to 15)
int Release[4] = {0, 0, 0, 0};     // (0 to 15)
int FreqLo[4] = {0, 0, 0, 0};      // (0 to 255)
int FreqHi[4] = {0, 16, 16, 16};   // (0 to 255)
int PulseWLo[4] = {0, 0, 0, 0};    // (0 to 255)
int PulseWHi[4] = {0, 8, 8, 8};    // (0 to 15)
int Waveshape[4] = {0, 0, 0, 0};   // Load with the bit values below

// bit values for the voice Waveshape (Control) register

const int NOISE = 128;
const int PULSE = 64;
const int SAWTOOTH = 32;
const int TRIANGLE = 16;
const int TEST = 8;
const int RINGMOD = 4;
const int SYNC = 2;

// bit values for filt of ldResFilt, add the ones you want, zero for none

const int FILTEX = 8;  // send external signal through the Filter
const int FILT3 = 4;   // send Voice 3 through the Filter
const int FILT2 = 2;   // send Voice 2 through the Filter
const int FILT1 = 1;   // send Voice 3 through the Filter

// bit values for mode of ldModeVol, add the ones you want, zero for none
  
const int OFF3 = 128;  // no Voice3 in the output (when used in ring modulation)
const int HP = 64;     // set Filter tos High Pass
const int BP = 32;     // set Filter to BandPass
const int LP = 16;     // set Filter to LowPass

unsigned long timestamp;
unsigned long duration;

const int LED = 20;

int freq=0;
int durA=0;
int durA_count=0;
int durB=0;
int durB_count=0;
int durC=0;
int durC_count=0;
int envA=0;
int envB=0;
int envC=0;
int dur=0;

bool sidVoice1_ON = 0;
bool sidVoice2_ON = 0;

//-------------------------------------------------------
//                      SETUP()
//-------------------------------------------------------


void setup() {

delay(1000);

//MIDI Callback Handle references here
//MIDI.begin(MIDI_CHANNEL_OMNI);

pinMode(LED, OUTPUT);
digitalWrite(LED, HIGH);

pinMode(AYBDIR, OUTPUT);
digitalWrite(AYBDIR, LOW);
pinMode(AYBC1, OUTPUT);
digitalWrite(AYBC1, LOW);
pinMode(AYBC2, OUTPUT);
digitalWrite(AYBC2, LOW);

pinMode(SIDRW, OUTPUT);
digitalWrite(SIDRW, LOW);    // High for Register Read, Low for Write
pinMode(SIDCS, OUTPUT);
digitalWrite(SIDCS, HIGH);   // Chip Select active low, Read/Write to register

pinMode(VoiceD1, OUTPUT);
digitalWrite(VoiceD1, LOW);
pinMode(VoiceD2, OUTPUT);
digitalWrite(VoiceD2, LOW);
pinMode(VoiceD3, OUTPUT);
digitalWrite(VoiceD3, LOW);

pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(Switch1, HIGH);
pinMode(Switch2, INPUT);
digitalWrite(Switch2, HIGH);
pinMode(Switch3, INPUT);
digitalWrite(Switch3, HIGH);
pinMode(Switch4, INPUT);
digitalWrite(Switch4, HIGH);

DDRA = B11111111;  // outputs
DDRB = B11111111;
DDRC = B11111111;
                    
// ~~~~~~~~~~~~~~Setup Synth values~~~~~~~~~~~~~~~~~~~~

resetSID();

Attack[1] = 12;
Decay[1] = 10;
ldEnvAD(1);
Sustainx[1] = 10;
Release[1] = 10;
ldEnvSR(1);
Waveshape[1] = SAWTOOTH;

Attack[3] = 0;
Decay[3] = 0;
ldEnvAD(3);
Sustainx[3] = 15;
Release[3] = 0;
ldEnvSR(3);
Waveshape[3] = TRIANGLE;

ldFiltRes(0, 8);
ldModeVol(OFF3 + LP, 15);

  
}  //end of Setup

//---------------------------------------------------------
//                    MAIN LOOP
//---------------------------------------------------------
  
void loop() {

 loadSensors();
 
//---------------------- Set SID Voices -------------------

Waveshape[1] = TRIANGLE + (!switch4 * RINGMOD) + (switch4 * SYNC);

  FreqHi[3] = (softPot >> 3) ;
  ldFreqHi(3);

  FreqHi[1] = (lightSensor4 >> 3) ;
  ldFreqHi(1);

if ((softPot > 10) && (sidVoice1_ON == 0)) {
    ldGate(1, 1);
    ldGate(3, 1);
    sidVoice1_ON = 1; 
  }

else if ((softPot < 10) && (sidVoice1_ON == 1)) {  
    ldGate(1, 0);
    ldGate(3, 0);
    sidVoice1_ON = 0; 
  }

   
// -----------Voice D from Arduino D6 ------------------

 
        dur = frontPot >> 3; //set envelope durations
      
        tone(VoiceD1, (lightSensor1 << 1));  // set frequencey of Voice D
        
     
      
// -----------Switch1 turns on noise in one voice ------------------

                AYldNoisePeriod(lightSensor3 >> 3); //Noise Frequency
                
                if (switch1){
                AYldEnable(B110000);  //Enable noise and tones in one voice (low enable)
                }
                else {
                AYldEnable(B111000);  //Enable only tones (low enable) 
                }          


// ------------Voice A from AY Chip---------------------

if (envA != 0){  //ramping down voice A envelope, 15 to 0

            if (durA_count != 0){  //wait for a count of durA
                  durA_count -= 1;
            }
              else {  // when the count reaches zero decrement voice A envelope, reset count 
                  durA_count = durA;
                  envA -= 1;
                  AYldAmpA(envA);
              }
  }    
  else{  // when envelope reaches zero, reset voice A with new frequency and envelope
    
            freq = getFreqA();  //get new random pitch for voice A
            AYldFineTuneA(freq & B11111111);
            AYldCourseTuneA(freq >>8);

            durA = random(1, dur) ;  // get random 8 bit duration for envelope A
            
            durA_count = durA;
            envA = 15;
            AYldAmpA(envA); //set voice A full on 
   }
                            
             

 // ------------Voice B from AY Chip---------------------

if (envB != 0){  //ramping down voice B envelope, 15 to 0

            if (durB_count != 0){  //wait for a count of durB
                  durB_count -= 1;
            }
              else {  // when the count reaches zero decrement voice B envelope, reset count 
                  durB_count = durB;
                  envB -= 1;
                  AYldAmpB(envB);
              }
  }    
  else{  // when envelope reaches zero, reset voice B with new frequency and envelope
    
            freq = getFreqB();  //get new random pitch for voice B
            AYldFineTuneB(freq & B11111111);
            AYldCourseTuneB(freq >>8);

            durB = random(1, dur) ;  // get random 8 bit duration for envelope B
            
            durB_count = durB;
            envB = 15;
            AYldAmpB(envB); //set voice B full on 
   }
                 

// ------------Voice C from AY Chip---------------------

if (envC != 0){  //ramping down voice C envelope, 15 to 0

            if (durC_count != 0){  //wait for a count of durC
                  durC_count -= 1;
            }
              else {  // when the count reaches zero decrement voice C envelope, reset count 
                  durC_count = durC;
                  envC -= 1;
                  AYldAmpC(envC);
              }
  }    
  else{  // when envelope reaches zero, reset voice C with new frequency and envelope
    
            freq = getFreqC();  //get new random pitch for voice C
            AYldFineTuneC(freq & B11111111);
            AYldCourseTuneC(freq >>8);

            durC = random(1, dur) ;  // get random 8 bit duration for envelope C
            
            durC_count = durC;
            envC = 15;
            AYldAmpC(envC); //set voice C full on 
   }
                                     
 // ------------Switch2  Slows everything to almost a standstill---------------------    
    
                             if (switch2 == 0){
                             delay(250);
   }
} // End of Loop

int getFreqA() {   // getting random frequency for Voices
        
    int basefreq = (slider1) + 10;
    int result = basefreq + random(slider4); // range of frequencies around the base
    return result;
}

int getFreqB() {   // getting random frequency for Voices
        
    int basefreq = (slider2) + 10;
    int result = basefreq + random(slider5); // range of frequencies around the base
    return result;
}

int getFreqC() {   // getting random frequency for Voices
        
    int basefreq = (slider3) + 10;
    int result = basefreq + random(slider6); // range of frequencies around the base
    return result;
}


//  _________________________________________________________________
//                AY Address and Data Load Functions
//  _________________________________________________________________

void AYloadAddress(int address){
  PORTA = (address & B1111);
  delayMicroseconds(2);
  
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
 
  digitalWrite(AYBDIR, LOW);
}

void AYloadData(int data){
    
  PORTA = data;

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}

void AYloadDataShort(int data){
  PORTA = (data & B111111);

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}


//  ____________________________________________________________________
//                AY General Control Register Load
//  ____________________________________________________________________

void AYldSynth(int address, int data){  // Load 4-bit Control Register Address then 8-bit data
  AYloadAddress(address);
  AYloadData(data);
}

//  ______________________________________________________________________
//                AY Individual Control Register Load 
//  _______________________________________________________________________


void AYldFineTuneA(int data){  //8-bit fine tune A
  AYloadAddress(AYFineTuneA);
  AYloadData(data);
}

void AYldFineTuneB(int data){  //8-bit fine tune B
  AYloadAddress(AYFineTuneB);
  AYloadData(data);
}

void AYldFineTuneC(int data){  //8-bit fine tune C
  AYloadAddress(AYFineTuneC);
  AYloadData(data);
}

void AYldCourseTuneA(int data){  //4-bit course tune A
  AYloadAddress(AYCourseTuneA);
  AYloadDataShort(data);
}

void AYldCourseTuneB(int data){  //4-bit course tune B
  AYloadAddress(AYCourseTuneB);
  AYloadDataShort(data);
}

void AYldCourseTuneC(int data){  //4-bit course tune C
  AYloadAddress(AYCourseTuneC);
  AYloadDataShort(data);
}

void AYldNoisePeriod(int data){  //5-bit noise period tune
  AYloadAddress(AYNoisePeriod);
  AYloadDataShort(data);
}

void AYldEnable(int data){  //Low 1-bit enable, Noise C/B/A Tone C/B/A
  AYloadAddress(AYEnable);
  AYloadDataShort(data);
}

void AYldAmpA(int amp){  //4-bit amplitude of A if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpA);
  AYloadDataShort(amp);
}

void AYldAmpB(int amp){  //4-bit amplitude of B if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpB);
  AYloadDataShort(amp);
}

void AYldAmpC(int amp){  //4-bit amplitude of C if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpC);
  AYloadDataShort(amp);
}

void AYldEnvFineTune(int data){  //8-bit Envelope Period fine tune
  AYloadAddress(AYEnvFineTune);
  AYloadData(data);
}

void AYldEnvCourseTune(int data){  //8-bit Envelope Period course tune
  AYloadAddress(AYEnvCourseTune);
  AYloadData(data);
}

void AYldEnvShape(int data){  //4-bit Envelope Shape. Continue/Attack/Alternate/Hold
  AYloadAddress(AYEnvShape);
  AYloadDataShort(data);
}


//  _________________________________________________________________
//                SID Basic Address and Data Functions
//  _________________________________________________________________

void loadAddress(int address){
 PORTB = address;
}

void loadData(int data){ 
  PORTC = data;   
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);  
  digitalWrite(SIDCS, HIGH);
}

void resetSID(){
  for(int i=0; i<25; i++){
    loadAddress(i);
    loadData(0);
  } 
  ldModeVol(LP, 255);
  }

void readRegisters(){      //Collect values of all 4 SID readable registers
  DDRC = B00000000;        //Setup Data Lines as Inputs
  digitalWrite(SIDRW, HIGH);  // Setup Read/Write for a Data Read
  
  loadAddress(25);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  potX = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);
  
  loadAddress(28);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  env3 = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);

  loadAddress(27);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  osc3_rand = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);

  loadAddress(26);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  potY = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);

  digitalWrite(SIDRW, LOW);  // Reset Read/Write to Data Write
  DDRC = B11111111;       // Reset Data Lines as Outputs
}


void loadSensors(){      // load all current sensor values
      slider1 =   analogRead(Slider1) >> 2;
      slider2 =   analogRead(Slider2) >> 2;
      slider3 =   analogRead(Slider3) >> 2;
      slider4 =   analogRead(Slider4) >> 2;
      slider5 =   analogRead(Slider5) >> 2;
      slider6 =   analogRead(Slider6) >> 2;
      softPot =   analogRead(SoftPot) >> 2;
      frontPot =  analogRead(FrontPot) >> 2;
      lightSensor1 =   analogRead(LightSensor1) >> 2;
      lightSensor2 =   analogRead(LightSensor2) >> 2;
      lightSensor3 =   analogRead(LightSensor3) >> 2;
      lightSensor4 =   analogRead(LightSensor4) >> 2;
      lightSensor5 =   analogRead(LightSensor5) >> 2;
      lightSensor6 =   analogRead(LightSensor6) >> 2;
      switch1 = digitalRead(Switch1);
      switch2 = digitalRead(Switch2);
      switch3 = digitalRead(Switch3);
      switch4 = digitalRead(Switch4);     
}
//  ____________________________________________________________________
//               SID Individual Control Register Load 
//  ____________________________________________________________________

  /*       ldFreqLo, ldFreqHi,        --voices 1, 2, 3   Frequency
           ldPulseWLo, ldPulseWHi,    --voices 1, 2, 3   Pulse Width
           ldGate,                    --voices 1, 2, 3   Gate the Envelope (+ Waveshape)
           ldEnvAD, ldEnvSR,          --voices 1, 2, 3   Envelope ADSR
           ldFCLo, ldFCHi, ldResFilt  --Filter Cutoff Frequency/Resonance
           ldModeVol                  --FilterType/OutputVolume
*/

void ldFreqLo(int voice){  //8-bit fine tune frequency -- FreqLo
  loadAddress(addr[voice]);
  loadData(FreqLo[voice] & 255);
}

void ldFreqHi(int voice){  //8-bit course tune frequency -- FreqHi
  loadAddress(addr[voice]+1);
  loadData(FreqHi[voice] & 255);
}

void ldPulseWLo(int voice){  //8-bit fine tune Pulse Width -- PulseWLo
  loadAddress(addr[voice]+2);
  loadData(PulseWLo[voice] & 255);
}

void ldPulseWHi(int voice){  //4-bit course tune Pulse Width -- PulseWHi
  loadAddress(addr[voice]+3);
  loadData(PulseWHi[voice] & 15);
}

void ldGate(int voice, int gate){  // Gates the ADSR Envelope (also loads Waveshape)
  
  loadAddress(addr[voice]+4);
  loadData(Waveshape[voice] + gate);
}

void ldEnvAD(int voice){  //4-bit Attack Time, 4-bit Decay time -- Env Attack/Decay
  loadAddress(addr[voice]+5);
  int x = ((Attack[voice] & 15) << 4) + (Decay[voice] & 15);
  loadData(x);
}


void ldEnvSR(int voice){  //4-bit Sustain Level, 4-bit Release time -- Env Sustain/Release
  loadAddress(addr[voice]+6);
  int x = ((Sustainx[voice] & 15) << 4) + (Release[voice] & 15);
  loadData(x);
}

void ldFCLo(int data){  //3-bit fine tune Filter Cutoff Frequency
  loadAddress(21);
  loadData(data & 7);
}

void ldFCHi(int data){  //8-bit course tune Filter Cutoff Frequency
  loadAddress(22);
  loadData(data & 255);
}

void ldFiltRes(int filt, int res){   //FILTEX/FILT3/FILT2/FILT1, 4-bit Filter Resonance, 
  loadAddress(23);
  int x = ((res & 15) << 4) + (filt & 15);
  loadData(x);
}

void ldModeVol(int mode, int vol){   //Filter Type 3OFF/HP/BP/LP, 4-bit Output Volume
  loadAddress(24);
  loadData((vol & 15) + (mode & B11110000));
}
//-------------------------------------------------------
