
/* 
      AY Synth Chip with Recordable MIDI IN

      ** MIDI Input Note ON and Note OFF handled by Callback functions
         MIDI Note Velocity sets AY note Amplitude. 3 voice polyphony with AY Voices
      ** Slider1 messes with the playback speed.
      ** Slider2 messes with the voice tunings.
      ** Tap bottom of SoftPot - to start and stop PLAYBACK.
         Tap Middle of SoftPot - to start and stop RECORD from MIDI Input
*/        
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Mega.  MIDI set up on Serial1, pins 18 and 19.

#include <MIDI.h>  // version 4.x.x
MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI); 

// User created MIDI Callback functions here or at end

 const int MIDI_TX = 18;  //on SERIAL1
 const int MIDI_RX = 19;  //on SERIAL1
// 
// ANALOG INPUTS
//
const int Slider1 = 0;
const int Slider2 = 1;
const int Slider3 = 2;
const int Slider4 = 3;
const int Slider5 = 4;
const int Slider6 = 5;
const int SoftPot = 6;
const int FrontPot = 7;
const int LightSensor1 = 8;
const int LightSensor2 = 9;
const int LightSensor3 = 10;
const int LightSensor4 = 11;
const int LightSensor5 = 12;
const int LightSensor6 = 13;

int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;
int slider5 = 0;
int slider6 = 0;
int softPot = 0;
int frontPot = 0;
int lightSensor1 = 0;
int lightSensor2 = 0;
int lightSensor3 = 0;
int lightSensor4 = 0;
int lightSensor5 = 0;
int lightSensor6 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 14;
const int Switch2 = 15;
const int Switch3 = 16;
const int Switch4 = 17;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

//
// AY SYTHESIZER CONSTANTS
//
const int AYBDIR = 2;  // set up names for some Arduino pins
const int AYBC1 = 4;
const int AYBC2 = 3;

const int AYFineTuneA = 0;  // AY Synth Control Registers
const int AYFineTuneB = 2;
const int AYFineTuneC = 4;
const int AYCourseTuneA = 1;
const int AYCourseTuneB = 3;
const int AYCourseTuneC = 5;
const int AYNoisePeriod = 6;
const int AYEnable = 7;
const int AYAmpA = 8;
const int AYAmpB = 9;
const int AYAmpC = 10;
const int AYEnvFineTune = 11;
const int AYEnvCourseTune = 12;
const int AYEnvShape = 13;

const int VoiceD1 = 7;
const int VoiceD2 = 8;
const int VoiceD3 = 9;

const int LED = 20;
int switchx = 0;

//AY frequency values for equal temperment A440 MIDI NoteON commands

byte AYMidiNoteHi[128] = {
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  14, 14, 13, 12, 11, 11, 10, 9, 9, 8, 8, 7, 
  7, 7, 6, 6, 5, 5, 5, 4, 4, 4, 4, 3, 
  3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0
};

byte AYMidiNoteLow[128] = {
  211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 
  239, 25, 78, 141, 218, 47, 143, 247, 104, 225, 97, 233, 
  119, 12, 167, 71, 237, 152, 71, 252, 180, 112, 49, 244, 
  188, 134, 83, 36, 246, 204, 164, 126, 90, 56, 24, 250, 
  222, 195, 170, 146, 123, 102, 82, 63, 45, 28, 12, 253, 
  239, 225, 213, 201, 190, 179, 169, 159, 150, 142, 134, 127, 
  119, 113, 106, 100, 95, 89, 84, 80, 75, 71, 67, 63, 
  60, 56, 53, 50, 47, 45, 42, 40, 38, 36, 34, 32, 
  30, 28, 27, 25, 24, 22, 21, 20, 19, 18, 17, 16, 
  15, 14, 13, 13, 12, 11, 11, 10, 9, 9, 8, 8, 
  7, 7, 7, 6, 6, 6, 5, 5
};

byte eventNotes[255] = {0};  //holds recorded Midi Input NoteOn
unsigned long eventTimes[255] = {0};  //holds recorded times of Notes
byte eventVelocity[255] = {0};  // holds recorded note velocities
byte eventVoice[255] = {0};   // holds recorded voice assignment of notes

unsigned long eventTime = 0;
int currentTime = 0;

int eventIndex = 0;  // holds position within the 4 record arrays
bool record = 0;
bool playback = 0;
bool triggerRecord = 0;
bool triggerPlayback = 0;

unsigned long startTime = 0; // created by timestamp()

//current note on's for voices A, B, and C.  Use note value 0 for "not on". 
byte CurrentNoteOn[3] = {0, 0, 0}; 

byte Mode[3] = { 0, 0, 0 };  // sets up volume by 4-bit Amp, or Envelopes
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

//MIDI Callback Handle references here
//MIDI.begin(MIDI_CHANNEL_OMNI);

  MIDI.setHandleNoteOn(myHandleNoteOn); //for Callback MIDI In 
  MIDI.setHandleNoteOff(myHandleNoteOff); //for Callback MIDI In 
  MIDI.begin(MIDI_CHANNEL_OMNI);
  
pinMode(LED, OUTPUT);

pinMode(AYBDIR, OUTPUT);
digitalWrite(AYBDIR, LOW);
pinMode(AYBC1, OUTPUT);
digitalWrite(AYBC1, LOW);
pinMode(AYBC2, OUTPUT);
digitalWrite(AYBC2, LOW);

pinMode(VoiceD1, OUTPUT);
digitalWrite(VoiceD1, LOW);
pinMode(VoiceD2, OUTPUT);
digitalWrite(VoiceD2, LOW);
pinMode(VoiceD3, OUTPUT);
digitalWrite(VoiceD3, LOW);


pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(Switch1, HIGH);
pinMode(Switch2, INPUT);
digitalWrite(Switch2, HIGH);
pinMode(Switch3, INPUT);
digitalWrite(Switch3, HIGH);
pinMode(Switch4, INPUT);
digitalWrite(Switch4, HIGH);

DDRA = B11111111;  // outputs
DDRB = B11111111;
DDRC = B11111111;

                    AYldEnable(B111000);  //Enable only tones (low enable)
                     
 Serial.begin(9600);
                                        
                    digitalWrite(LED, HIGH);
                    playEvent(40, 70, 0); 
                    delay(100);
                    playEvent(60, 70, 1); 
                    delay(100);
                    playEvent(80, 70, 2); 
                    delay(100);                   
                    digitalWrite(LED, LOW);
                    playEvent(40, 0, 0);
                    playEvent(40, 0, 1);
                    playEvent(40, 0, 2);
} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

loadSensors();
tone(VoiceD1, (frontPot >> 2));  // set frequency of Voice D
                                           

// On MIDI.read() MIDI class will call Callback functions.
// User created callback function myHandleNoteOn() and myHandleNoteOff() at end
// MIDI.setHandleNoteOn(myHandleNoteOn), MIDI.setHandleNoteOff(myHandleNoteOff) in setup() 

//
//--------------Use SoftPot taps to start and stop record or playback -------------
//

if ((softPot > 400) && (softPot < 600)){ triggerRecord = 1; delay(500); }  //Middle
else if ((softPot > 15) && (softPot < 200)){ triggerPlayback = 1; delay(500); } //Bottom

                  if (triggerRecord && !record){  //start record
                      triggerRecord = 0;
                      playback = 0;
                      record = 1;
                      digitalWrite(LED, HIGH);
                      eventIndex = 0;
                                for (int i=0; i < 255; i++){
                                    eventNotes[i] = 255;
                                    eventTimes[i] = 0;
                                }
                       timestamp();
                       
                  }
                  
                  else if (triggerPlayback && !playback){  //start playback
                      triggerPlayback = 0;
                      record = 0;
                      digitalWrite(LED, LOW);
                      playback = 1;
                      eventIndex = 0;
                      timestamp();                                                                 
                  }
                  
                  else if (triggerRecord && record){  //stop record
                      triggerRecord = 0;
                      playback = 0;
                      record = 0;
                      digitalWrite(LED, LOW);  
                  }
                  
                  else if (triggerPlayback && playback){  //stop playback
                      triggerPlayback = 0;
                      record = 0;
                      digitalWrite(LED, LOW);
                      playback = 0;
                      AYldAmpA(0);
                      AYldAmpB(0);
                      AYldAmpC(0);
                  
                  }
//--------------------------------------------------------------------------------

                 MIDI.read();
//
//---------------Playback of Notes[] at Times []-----------------------------
//

      while (playback) {
       
           currentTime = dur();                    
           while (eventTimes[eventIndex] <= currentTime){            
           playEvent(eventNotes[eventIndex], eventVelocity[eventIndex], eventVoice[eventIndex]);
                        eventIndex = eventIndex + 1;
                        if (eventNotes[eventIndex] == 255){   // no more recorded notes                             
                              eventIndex = 0;              // rewind to beginning
                              timestamp();                              
                              break;
                        }  //  end of rewind 
           } // end of while              
                                break;                     
      } //end of while playback


} //End of Main Loop


void loadSensors(){      // load all current sensor values
      slider1 =   analogRead(Slider1);
      slider2 =   analogRead(Slider2);
      slider3 =   analogRead(Slider3);
      slider4 =   analogRead(Slider4);
      slider5 =   analogRead(Slider5);
      slider6 =   analogRead(Slider6);
      softPot =   analogRead(SoftPot);
      frontPot =  analogRead(FrontPot);
      lightSensor1 =   analogRead(LightSensor1) >> 2;
      lightSensor2 =   analogRead(LightSensor2) >> 2;
      lightSensor3 =   analogRead(LightSensor3) >> 2;
      lightSensor4 =   analogRead(LightSensor4) >> 2;
      lightSensor5 =   analogRead(LightSensor5) >> 2;
      lightSensor6 =   analogRead(LightSensor6) >> 2;
      switch1 = digitalRead(Switch1);
      switch2 = digitalRead(Switch2);
      switch3 = digitalRead(Switch3);
      switch4 = digitalRead(Switch4);     
}
 
//  _________________________________________________________________
//                AY Address and Data Load Functions
//  _________________________________________________________________

void AYloadAddress(int address){
  PORTA = (address & B1111);
  delayMicroseconds(2);
  
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
 
  digitalWrite(AYBDIR, LOW);
}

void AYloadData(int data){
    
  PORTA = data;

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}

void AYloadDataShort(int data){
  PORTA = (data & B111111);

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}


//  ____________________________________________________________________
//                AY General Control Register Load
//  ____________________________________________________________________

void AYldSynth(int address, int data){  // Load 4-bit Control Register Address then 8-bit data
  AYloadAddress(address);
  AYloadData(data);
}

//  ______________________________________________________________________
//                AY Individual Control Register Load 
//  _______________________________________________________________________


void AYldFineTuneA(int data){  //8-bit fine tune A
  AYloadAddress(AYFineTuneA);
  AYloadData(data);
}

void AYldFineTuneB(int data){  //8-bit fine tune B
  AYloadAddress(AYFineTuneB);
  AYloadData(data);
}

void AYldFineTuneC(int data){  //8-bit fine tune C
  AYloadAddress(AYFineTuneC);
  AYloadData(data);
}

void AYldCourseTuneA(int data){  //4-bit course tune A
  AYloadAddress(AYCourseTuneA);
  AYloadDataShort(data);
}

void AYldCourseTuneB(int data){  //4-bit course tune B
  AYloadAddress(AYCourseTuneB);
  AYloadDataShort(data);
}

void AYldCourseTuneC(int data){  //4-bit course tune C
  AYloadAddress(AYCourseTuneC);
  AYloadDataShort(data);
}

void AYldNoisePeriod(int data){  //5-bit noise period tune
  AYloadAddress(AYNoisePeriod);
  AYloadDataShort(data);
}

void AYldEnable(int data){  //Low 1-bit enable, Noise C/B/A Tone C/B/A
  AYloadAddress(AYEnable);
  AYloadDataShort(data);
}

void AYldAmpA(int amp){  //4-bit amplitude of A if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpA);
  AYloadDataShort(amp);
}

void AYldAmpB(int amp){  //4-bit amplitude of B if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpB);
  AYloadDataShort(amp);
}

void AYldAmpC(int amp){  //4-bit amplitude of C if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpC);
  AYloadDataShort(amp);
}

void AYldEnvFineTune(int data){  //8-bit Envelope Period fine tune
  AYloadAddress(AYEnvFineTune);
  AYloadData(data);
}

void AYldEnvCourseTune(int data){  //8-bit Envelope Period course tune
  AYloadAddress(AYEnvCourseTune);
  AYloadData(data);
}

void AYldEnvShape(int data){  //4-bit Envelope Shape. Continue/Attack/Alternate/Hold
  AYloadAddress(AYEnvShape);
  AYloadDataShort(data);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      Callback MIDI_In Handles
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// user created Callback Function for MIDI Input Test

 void myHandleNoteOn(byte channel, byte note, byte velocity){
  
    for (int x = 0; x < 3; x ++){    // search through the 3 AY voices

    if (CurrentNoteOn[x] == 0){      // this AY voice is available
                        
                   playEvent(note, velocity, x);
                   AYldEnvShape(!switch4 + (!switch3 * 2) + (!switch2 * 4) + (!switch1 * 8));               
                   if (velocity == 0) {CurrentNoteOn[x] = 0; } 
                   else {CurrentNoteOn[x] = note; }  
                   if (record){ loadEventArrays(note, velocity, x); }                                                                             
                 break;  //  break out of voice search loop   
                                              
     }  // end of Note On check

     
}  // end of for loop
}  // end of Handle
 
 void myHandleNoteOff(byte channel, byte note, byte velocity){
 for (int x = 0; x < 3; x ++){          // search through the 3 AY voices

    if (CurrentNoteOn[x] == note){      // which voice is playing the note to turn off?

                 switch (x) {           
                 case 0:  
                   AYldAmpA(0);                    
                   CurrentNoteOn[x] = 0;
                   if (record){ loadEventArrays(note, 0, 0); }      
                   break;                                 
                case 1:
                   AYldAmpB(0);                    
                   CurrentNoteOn[x] = 0; 
                   if (record){ loadEventArrays(note, 0, 1); }          
                   break;                                 
                case 2:
                  AYldAmpC(0);                    
                   CurrentNoteOn[x] = 0;
                   if (record){ loadEventArrays(note, 0, 2); }            
                   break;       
                 }  // end of switch 
                                                                           
     }  // end of Note check

     
}  // end of for loop
}  //end of Handle

void loadEventArrays(int note, int velocity, int voice){
  eventTimes[eventIndex] = dur();
  eventNotes[eventIndex] = note;
  eventVelocity[eventIndex] = velocity;
  eventVoice[eventIndex] = voice;
  eventIndex = eventIndex + 1;
}

void playEvent(int n, int v, int AYvoice){
        switch (AYvoice) {           
                 case 0:                   
                   AYldCourseTuneA(AYMidiNoteHi[n]);
                   AYldFineTuneA(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = ((v >> 4) + 6) & 15;}
                   AYldAmpA(v + Mode[0]);                   
                   break;                                 
                case 1:
                   AYldCourseTuneB(AYMidiNoteHi[n]);
                   AYldFineTuneB(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = ((v >> 4) + 6) & 15;}
                   AYldAmpB(v + Mode[1]);                     
                   break;                                 
                case 2:
                   AYldCourseTuneC(AYMidiNoteHi[n]);
                   AYldFineTuneC(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = ((v >> 4) + 6) & 15;}
                   AYldAmpC(v + Mode[2]);                        
                   break;       
                 }  // end of switch 
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//              TIMER  Loop Functions
//  ______________________________________________________________________________

void timestamp() {startTime = millis(); };
// store current time from the running clock millis()

unsigned long dur(){
  return ((millis() + (slider1 * 2)) - startTime);
}
// returns the current time minus the last store timestamp

void waitTill(unsigned long msec) {
  while (dur() < msec) {};
}
//wait till the time duration from timestamp equals the given time in msec






