
/* 
      3 squarewave tones produced from Arduino pins 7, 8, and 9
      A hardware diode gate modulates them together
      
      Slider1 - Sets Frequency of Tone1 from arduino tone()
      Slider2 - Sets Frequency of Tone2
      Slider3 - Sets Frequency of Tone3 
      Slider4 - Sets the decrement clock

      Switch1 - turns off or on Tone2
      Switch2 - turns off or on Tone3     
*/        
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     PIN# CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// ANALOG INPUT PINS
//
const int Slider1 = 0;
const int Slider2 = 1;
const int Slider3 = 2;
const int Slider4 = 3;
const int Slider5 = 4;
const int Slider6 = 5;
const int SoftPot = 6;
const int FrontPot = 7;
const int LightSensor1 = 8;
const int LightSensor2 = 9;
const int LightSensor3 = 10;
const int LightSensor4 = 11;
const int LightSensor5 = 12;
const int LightSensor6 = 13;

//
//DIGITAL SWITCH PINS
//
const int Switch1 = 14;
const int Switch2 = 15;
const int Switch3 = 16;
const int Switch4 = 17;

//
//VOICE OUTPUT PINS
//
const int VoiceD1 = 7;
const int VoiceD2 = 8;
const int VoiceD3 = 9;

//
// AY SYTHESIZER PINS
//
const int AYBDIR = 2;  
const int AYBC1 = 4;
const int AYBC2 = 3;

//
//SID SYNTHESIZER PINS
//
const int SIDCS = 5;
const int SIDRW = 6;

const int LED = 20;  

int freq2 = 100;  //variables to set voice frequencies
int freq3 = 100;
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

pinMode(LED, OUTPUT);

pinMode(SIDRW, OUTPUT);
digitalWrite(SIDRW, LOW);    
pinMode(SIDCS, OUTPUT);
digitalWrite(SIDCS, HIGH); 

pinMode(AYBDIR, OUTPUT);
digitalWrite(AYBDIR, LOW);
pinMode(AYBC1, OUTPUT);
digitalWrite(AYBC1, LOW);
pinMode(AYBC2, OUTPUT);
digitalWrite(AYBC2, LOW);

pinMode(VoiceD1, OUTPUT);
digitalWrite(VoiceD1, LOW);
pinMode(VoiceD2, OUTPUT);
digitalWrite(VoiceD2, LOW);
pinMode(VoiceD3, OUTPUT);
digitalWrite(VoiceD3, LOW);

pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(Switch1, HIGH);
pinMode(Switch2, INPUT);
digitalWrite(Switch2, HIGH);
pinMode(Switch3, INPUT);
digitalWrite(Switch3, HIGH);
pinMode(Switch4, INPUT);
digitalWrite(Switch4, HIGH);

DDRA = B11111111;  // pins set as buss outputs for Synth register inputs
DDRB = B11111111;
DDRC = B11111111;

digitalWrite(LED, HIGH); //Power On indicator light                           
                   
} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {
  
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      VOICE 1
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                                         
    tone(VoiceD1, (analogRead(Slider1) << 2));             // set frequency of Voice1 using tone()

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     DECREMENT LOOP CLOCK
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    delayMicroseconds(analogRead(Slider4) << 4);           // wait before continuing, sets main decrement clock

// Arduino's tone() function can only be used to set up a squarewave on one output.
// Two more voices are created from a fast loop clock decrementing two freq values and toggling voice outputs
// when they reach zero.  The freq values determine the frequency of the voices.

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      VOICE 2
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                                                   
      if (digitalRead(Switch1) == 1) {
        digitalWrite(VoiceD2, LOW);                        // Switch1 can turn off Tone2 by bypassing else{}
      }
      else{
        --freq2;                                           // decrement freq from its starting slider value 
        if (freq2 <= 0){                                   // on reaching zero, do next two operations ...
            digitalWrite(VoiceD2, !digitalRead(VoiceD2));  // toggle voice output, creating squarewave
            freq2 = analogRead(Slider2) >> 4;              // reset to Slider value which determines voice frequency
        }
      }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      VOICE 3
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      if (digitalRead(Switch2) == 1) {                     // same as above for third voice 
        digitalWrite(VoiceD3, LOW);   
      }
      else{
        --freq3;
        if (freq3 <= 0){
            digitalWrite(VoiceD3, !digitalRead(VoiceD3));
            freq3 = analogRead(Slider3) >> 4;
      }
        }       
} 

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

