
/* 
      Full functioning AY Synth Chip with MIDI IN

      ** MIDI Input Note ON and Note OFF handled by Callback function
         MIDI Note Velocity sets AY note Amplitude. 3 voice polyphony with AY Voices
      ** Slider1 controls Noise frequency, Noise turns on with slider1 above zero
      ** Sliders 4, 5, and 6 act as pitch wheels and detuning for AY voices A, B, and C
      ** Tap bottom of SoftPot - All 3 AY voices get levels from their AMP Controls
         Tap Middle of SoftPot - VoiceA is on the AY Envelope, Voices B and C on AMP Control
         Tap Top of SoftPot - All 3 AY voices on the AY Envelope
      ** Slider2 and Slider3 control Envelope Period, Course and Fine.           
      ** Switches 1-4 set the AY Envelope type.
               Switch 1 - set to zero for single attack on MIDI Note ON
               Switch 2 - 0 is instant attack then decay, 1 is slow attack
               Switch 3 - 0 for Sawtooth, 1 for Triangle
               Switch 4 - 0 for repeating, 1 for single
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Mega.  MIDI set up on Serial1, pins 18 and 19.

#include <MIDI.h>  // version 4.x.x
MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI); 

// User created MIDI Callback functions here or at end

 const int MIDI_TX = 18;  //on SERIAL1
 const int MIDI_RX = 19;  //on SERIAL1
// 
// ANALOG INPUTS
//
const int Slider1 = 0;
const int Slider2 = 1;
const int Slider3 = 2;
const int Slider4 = 3;
const int Slider5 = 4;
const int Slider6 = 5;
const int SoftPot = 6;
const int FrontPot = 7;
const int LightSensor1 = 8;
const int LightSensor2 = 9;
const int LightSensor3 = 10;
const int LightSensor4 = 11;
const int LightSensor5 = 12;
const int LightSensor6 = 13;

int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;
int slider5 = 0;
int slider6 = 0;
int softPot = 0;
int frontPot = 0;
int lightSensor1 = 0;
int lightSensor2 = 0;
int lightSensor3 = 0;
int lightSensor4 = 0;
int lightSensor5 = 0;
int lightSensor6 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 14;
const int Switch2 = 15;
const int Switch3 = 16;
const int Switch4 = 17;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

//
// AY SYTHESIZER CONSTANTS
//
const int AYBDIR = 2;  // set up names for some Arduino pins
const int AYBC1 = 4;
const int AYBC2 = 3;

const int AYFineTuneA = 0;  // AY Synth Control Registers
const int AYFineTuneB = 2;
const int AYFineTuneC = 4;
const int AYCourseTuneA = 1;
const int AYCourseTuneB = 3;
const int AYCourseTuneC = 5;
const int AYNoisePeriod = 6;
const int AYEnable = 7;
const int AYAmpA = 8;
const int AYAmpB = 9;
const int AYAmpC = 10;
const int AYEnvFineTune = 11;
const int AYEnvCourseTune = 12;
const int AYEnvShape = 13;

const int VoiceD1 = 7;
const int VoiceD2 = 8;
const int VoiceD3 = 9;

const int LED = 20;
int switchx = 0;

//AY frequency values for equal temperment A440 MIDI NoteON commands

byte AYMidiNoteHi[128] = {
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  14, 14, 13, 12, 11, 11, 10, 9, 9, 8, 8, 7, 
  7, 7, 6, 6, 5, 5, 5, 4, 4, 4, 4, 3, 
  3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0
};

byte AYMidiNoteLow[128] = {
  211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 
  239, 25, 78, 141, 218, 47, 143, 247, 104, 225, 97, 233, 
  119, 12, 167, 71, 237, 152, 71, 252, 180, 112, 49, 244, 
  188, 134, 83, 36, 246, 204, 164, 126, 90, 56, 24, 250, 
  222, 195, 170, 146, 123, 102, 82, 63, 45, 28, 12, 253, 
  239, 225, 213, 201, 190, 179, 169, 159, 150, 142, 134, 127, 
  119, 113, 106, 100, 95, 89, 84, 80, 75, 71, 67, 63, 
  60, 56, 53, 50, 47, 45, 42, 40, 38, 36, 34, 32, 
  30, 28, 27, 25, 24, 22, 21, 20, 19, 18, 17, 16, 
  15, 14, 13, 13, 12, 11, 11, 10, 9, 9, 8, 8, 
  7, 7, 7, 6, 6, 6, 5, 5
};

//current note on's for voices A, B, and C.  Use note value 0 for "not on". 
byte CurrentNoteOn[3] = {0, 0, 0}; 

byte Mode[3] = { 0, 0, 0 };  // sets up volume by 4-bit Amp, or Envelopes
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);

//MIDI Callback Handle references here
//MIDI.begin(MIDI_CHANNEL_OMNI);

  MIDI.setHandleNoteOn(myHandleNoteOn); //for Callback MIDI In 
  MIDI.setHandleNoteOff(myHandleNoteOff); //for Callback MIDI In 
  MIDI.begin(MIDI_CHANNEL_OMNI);
  
pinMode(LED, OUTPUT);
digitalWrite(LED, HIGH);

pinMode(AYBDIR, OUTPUT);
digitalWrite(AYBDIR, LOW);
pinMode(AYBC1, OUTPUT);
digitalWrite(AYBC1, LOW);
pinMode(AYBC2, OUTPUT);
digitalWrite(AYBC2, LOW);

pinMode(VoiceD1, OUTPUT);
digitalWrite(VoiceD1, LOW);
pinMode(VoiceD2, OUTPUT);
digitalWrite(VoiceD2, LOW);
pinMode(VoiceD3, OUTPUT);
digitalWrite(VoiceD3, LOW);


pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(Switch1, HIGH);
pinMode(Switch2, INPUT);
digitalWrite(Switch2, HIGH);
pinMode(Switch3, INPUT);
digitalWrite(Switch3, HIGH);
pinMode(Switch4, INPUT);
digitalWrite(Switch4, HIGH);

DDRA = B11111111;  // outputs
DDRB = B11111111;
DDRC = B11111111;

                    AYldEnable(B111000);  //Enable only tones (low enable)
                     
 Serial.begin(9600);

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

loadSensors();
tone(VoiceD1, (frontPot >> 2));  // set frequency of Voice D

     
// -----------slider1 turns on noise, noise freq on slider1  ------------------
                                
                if (slider1 > 10){ AYldEnable(B000000);  // add noise to all 3 voices
                                   AYldNoisePeriod(slider1 >> 5); //Noise Frequency
                }
                else {AYldEnable(B111000);  } //Enable only tones (low enable)  

// ----------------add note glide/detune on each voice--------------------------

                 AYldFineTuneA(AYMidiNoteLow[CurrentNoteOn[0]] - (slider4 >> 3) );
                 AYldFineTuneB(AYMidiNoteLow[CurrentNoteOn[1]] - (slider5 >> 3) );
                 AYldFineTuneC(AYMidiNoteLow[CurrentNoteOn[2]] - (slider6 >> 3) );

// -----------------Envelopes --------------------------------------------------

       if (softPot > 15 && softPot < 200) { //Serial.print(softPot); Serial.println(" bottom"); 
                                          Mode[0]=0; Mode[1]=0; Mode[2]=0; delay(1000); }
       else if (softPot > 400 && softPot < 600){ //Serial.print(softPot); Serial.println( " middle");
                                               Mode[0] = 16; Mode[1]=0; Mode[2]=0; delay(1000); }
       else if (softPot > 800) { //Serial.print(softPot); Serial.println(" top");
                                 Mode[0]=16; Mode[1]=16; Mode[2]=16; delay(1000); }
          
            AYldEnvFineTune(slider3 >> 2);
            AYldEnvCourseTune(slider2 >> 2);
// ------------------------------------------------------------------------------                                                   

// On MIDI.read() MIDI class will call Callback functions.
// User created callback function myHandleNoteOn() and myHandleNoteOff() at end
// MIDI.setHandleNoteOn(myHandleNoteOn), MIDI.setHandleNoteOff(myHandleNoteOff) in setup() 

MIDI.read();

} //End of Main Loop


void loadSensors(){      // load all current sensor values
      slider1 =   analogRead(Slider1);
      slider2 =   analogRead(Slider2);
      slider3 =   analogRead(Slider3);
      slider4 =   analogRead(Slider4);
      slider5 =   analogRead(Slider5);
      slider6 =   analogRead(Slider6);
      softPot =   analogRead(SoftPot);
      frontPot =  analogRead(FrontPot);
      lightSensor1 =   analogRead(LightSensor1) >> 2;
      lightSensor2 =   analogRead(LightSensor2) >> 2;
      lightSensor3 =   analogRead(LightSensor3) >> 2;
      lightSensor4 =   analogRead(LightSensor4) >> 2;
      lightSensor5 =   analogRead(LightSensor5) >> 2;
      lightSensor6 =   analogRead(LightSensor6) >> 2;
      switch1 = digitalRead(Switch1);
      switch2 = digitalRead(Switch2);
      switch3 = digitalRead(Switch3);
      switch4 = digitalRead(Switch4);     
}
 
//  _________________________________________________________________
//                AY Address and Data Load Functions
//  _________________________________________________________________

void AYloadAddress(int address){
  PORTA = (address & B1111);
  delayMicroseconds(2);
  
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
 
  digitalWrite(AYBDIR, LOW);
}

void AYloadData(int data){
    
  PORTA = data;

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}

void AYloadDataShort(int data){
  PORTA = (data & B111111);

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}


//  ____________________________________________________________________
//                AY General Control Register Load
//  ____________________________________________________________________

void AYldSynth(int address, int data){  // Load 4-bit Control Register Address then 8-bit data
  AYloadAddress(address);
  AYloadData(data);
}

//  ______________________________________________________________________
//                AY Individual Control Register Load 
//  _______________________________________________________________________


void AYldFineTuneA(int data){  //8-bit fine tune A
  AYloadAddress(AYFineTuneA);
  AYloadData(data);
}

void AYldFineTuneB(int data){  //8-bit fine tune B
  AYloadAddress(AYFineTuneB);
  AYloadData(data);
}

void AYldFineTuneC(int data){  //8-bit fine tune C
  AYloadAddress(AYFineTuneC);
  AYloadData(data);
}

void AYldCourseTuneA(int data){  //4-bit course tune A
  AYloadAddress(AYCourseTuneA);
  AYloadDataShort(data);
}

void AYldCourseTuneB(int data){  //4-bit course tune B
  AYloadAddress(AYCourseTuneB);
  AYloadDataShort(data);
}

void AYldCourseTuneC(int data){  //4-bit course tune C
  AYloadAddress(AYCourseTuneC);
  AYloadDataShort(data);
}

void AYldNoisePeriod(int data){  //5-bit noise period tune
  AYloadAddress(AYNoisePeriod);
  AYloadDataShort(data);
}

void AYldEnable(int data){  //Low 1-bit enable, Noise C/B/A Tone C/B/A
  AYloadAddress(AYEnable);
  AYloadDataShort(data);
}

void AYldAmpA(int amp){  //4-bit amplitude of A if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpA);
  AYloadDataShort(amp);
}

void AYldAmpB(int amp){  //4-bit amplitude of B if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpB);
  AYloadDataShort(amp);
}

void AYldAmpC(int amp){  //4-bit amplitude of C if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpC);
  AYloadDataShort(amp);
}

void AYldEnvFineTune(int data){  //8-bit Envelope Period fine tune
  AYloadAddress(AYEnvFineTune);
  AYloadData(data);
}

void AYldEnvCourseTune(int data){  //8-bit Envelope Period course tune
  AYloadAddress(AYEnvCourseTune);
  AYloadData(data);
}

void AYldEnvShape(int data){  //4-bit Envelope Shape. Continue/Attack/Alternate/Hold
  AYloadAddress(AYEnvShape);
  AYloadDataShort(data);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      Callback MIDI_In Handles
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// user created Callback Function for MIDI Input Test

 void myHandleNoteOn(byte channel, byte note, byte velocity){
  
    for (int x = 0; x < 3; x ++){    // search through the 3 AY voices

    if (CurrentNoteOn[x] == 0){      // this AY voice is available
                        
                   playEvent(note, velocity, x);
                   AYldEnvShape(!switch4 + (!switch3 * 2) + (!switch2 * 4) + (!switch1 * 8));               
                   if (velocity == 0) {CurrentNoteOn[x] = 0; } 
                   else {CurrentNoteOn[x] = note; }  
                                                                                           
                 break;  //  break out of voice search loop   
                                              
     }  // end of Note On check

     
}  // end of for loop
}  // end of Handle


 void myHandleNoteOff(byte channel, byte note, byte velocity){
 for (int x = 0; x < 3; x ++){          // search through the 3 AY voices

    if (CurrentNoteOn[x] == note){      // which voice is playing the note to turn off?

                 switch (x) {           
                 case 0:  
                   AYldAmpA(0);                    
                   CurrentNoteOn[x] = 0;     
                   break;                                 
                case 1:
                   AYldAmpB(0);                    
                   CurrentNoteOn[x] = 0;          
                   break;                                 
                case 2:
                  AYldAmpC(0);                    
                   CurrentNoteOn[x] = 0;           
                   break;       
                 }  // end of switch 
                                                                           
     }  // end of Note check

     
}  // end of for loop
}  //end of Handle

void playEvent(int n, int v, int AYvoice){
        switch (AYvoice) {           
                 case 0:                   
                   AYldCourseTuneA(AYMidiNoteHi[n]);
                   AYldFineTuneA(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = ((v >> 4) + 6) & 15;}
                   AYldAmpA(v + Mode[0]);                   
                   break;                                 
                case 1:
                   AYldCourseTuneB(AYMidiNoteHi[n]);
                   AYldFineTuneB(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = ((v >> 4) + 6) & 15;}
                   AYldAmpB(v + Mode[1]);                     
                   break;                                 
                case 2:
                   AYldCourseTuneC(AYMidiNoteHi[n]);
                   AYldFineTuneC(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = ((v >> 4) + 6) & 15;}
                   AYldAmpC(v + Mode[2]);                        
                   break;       
                 }  // end of switch 
}






