
/* 
                       MIDI OUT tested
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include <MIDI.h>  // version 4.x.x
MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI); 

// for use on an Arduino Mega.  Midi set up on Serial1, pins 18 and 19.

 const int MIDI_TX = 18;  //on SERIAL1
 const int MIDI_RX = 19;  //on SERIAL1
// 
// ANALOG INPUTS
//
const int Slider1 = 0;
const int Slider2 = 1;
const int Slider3 = 2;
const int Slider4 = 3;
const int Slider5 = 4;
const int Slider6 = 5;
const int SoftPot = 6;
const int FrontPot = 7;
const int LightSensor1 = 8;
const int LightSensor2 = 9;
const int LightSensor3 = 10;
const int LightSensor4 = 11;
const int LightSensor5 = 12;
const int LightSensor6 = 13;

int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;
int slider5 = 0;
int slider6 = 0;
int softPot = 0;
int frontPot = 0;
int lightSensor1 = 0;
int lightSensor2 = 0;
int lightSensor3 = 0;
int lightSensor4 = 0;
int lightSensor5 = 0;
int lightSensor6 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 14;
const int Switch2 = 15;
const int Switch3 = 16;
const int Switch4 = 17;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;



const int LED = 20;
int switchx = 0;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);

  MIDI.begin(MIDI_CHANNEL_OMNI);
  
pinMode(LED, OUTPUT);
digitalWrite(LED, HIGH);


pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(Switch1, HIGH);
pinMode(Switch2, INPUT);
digitalWrite(Switch2, HIGH);
pinMode(Switch3, INPUT);
digitalWrite(Switch3, HIGH);
pinMode(Switch4, INPUT);
digitalWrite(Switch4, HIGH);

DDRA = B11111111;  // outputs
DDRB = B11111111;
DDRC = B11111111;
                    

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

 // before setup() use:   #include <MIDI.h> 
//  and MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI);
//  in setup() use: MIDI.begin(MIDI_CHANNEL_OMNI); 


 for (int i=30; i<60; i++){  //play notes going up
  
  loadSensors();
  int dur = slider1 + 20;  // note duration
  int velocity = slider2;  // note velocity
  velocity = map(velocity, 0, 255, 0, 127);
  
  MIDI.sendNoteOn(i, velocity, 1);  //main note_on, note_off
  delay(dur);
  MIDI.sendNoteOff(i, velocity, 1);
  delay(dur);

    if (!switch1){  //All notes off button
    for (int j=0; j<127; j++){
      MIDI.sendNoteOff(i, 0, 1);
    }
  }

  if (!switch2){  //Random Program Change button
    int prog = random(0, 127);
    MIDI.sendProgramChange(prog, 1);
  }

stopped:
  if(!switch3){  //stop button
    switch3 = digitalRead(Switch3);
    goto stopped;
  }
  
  
 }  //End of ramping notes
} //End of Main Loop



void loadSensors(){      // load all current sensor values
      slider1 =   analogRead(Slider1) >> 2;
      slider2 =   analogRead(Slider2) >> 2;
      slider3 =   analogRead(Slider3) >> 2;
      slider4 =   analogRead(Slider4) >> 2;
      slider5 =   analogRead(Slider5) >> 2;
      slider6 =   analogRead(Slider6) >> 2;
      softPot =   analogRead(SoftPot) >> 2;
      frontPot =  analogRead(FrontPot) >> 2;
      lightSensor1 =   analogRead(LightSensor1) >> 2;
      lightSensor2 =   analogRead(LightSensor2) >> 2;
      lightSensor3 =   analogRead(LightSensor3) >> 2;
      lightSensor4 =   analogRead(LightSensor4) >> 2;
      lightSensor5 =   analogRead(LightSensor5) >> 2;
      lightSensor6 =   analogRead(LightSensor6) >> 2;
      switch1 = digitalRead(Switch1);
      switch2 = digitalRead(Switch2);
      switch3 = digitalRead(Switch3);
      switch4 = digitalRead(Switch4);     
}






