
/* 
      Performance Patch for AYSID

      ** MIDI Input Note ON and Note OFF handled by Callback functions playing the 3 AY voices
          AY note Amplitude set at max of 15. 3 voice polyphony with AY Voices
         MIDI Input can be recorded -- tap the middle of softPot to start recording (LED turns on)
                                       tap again to stop recording (LED turns off)
                                       tap the bottom of the softPot to start and stop playback
      ** Slider1 affects AY voice playback speed somewhat.
      ** Slider2 affects AY voice playback tunings.
      ** Slider3 and lightSensor3 affect SID voice 3 (ring modulation) frequency
      ** Slider4 and lightSensor4 affect SID voice 1 frequency
      ** Slider5 and lightSensor5 affect SID voice 2 frequency
      ** Slider6 affects Pulse Width of voice 2, and cutoff frequency of the LowPass filter
      * 
      ** lightSensor1 triggers Attack and/or Release of SID voice 1 Envelopes
      ** lightSensor2 triggers Attack and/or Release of SID voice 2 Envelopes
      * 
      ** Switch1 Sends SID Voice 1 throught the LowPass Filter
      ** Switch2 Sends SID Voice 2 throught the LowPass Filter
      ** Switch3 turns on Ring Modulation between SIO voice 1 and 3
      ** Switch4 turns on Sync Modulation between SID voice 2 and 1, defaults to Voice 2 Pulse Waveform
      * 
      * 
      * Front Panel Pot controls frequency of Arduino Voice D modulating the AY voices
     
*/        
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// For use on an Arduino Mega.  MIDI set up on Serial1, pins 18 and 19.

#include <MIDI.h>  // version 4.x.x
MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI); 

// User created MIDI Callback functions here or at end

 const int MIDI_TX = 18;  //on SERIAL1
 const int MIDI_RX = 19;  //on SERIAL1
// 
// ANALOG INPUTS
//
const int Slider1 = 0;
const int Slider2 = 1;
const int Slider3 = 2;
const int Slider4 = 3;
const int Slider5 = 4;
const int Slider6 = 5;
const int SoftPot = 6;
const int FrontPot = 7;
const int LightSensor1 = 8;
const int LightSensor2 = 9;
const int LightSensor3 = 10;
const int LightSensor4 = 11;
const int LightSensor5 = 12;
const int LightSensor6 = 13;

int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;
int slider5 = 0;
int slider6 = 0;
int softPot = 0;
int frontPot = 0;
int lightSensor1 = 0;
int lightSensor2 = 0;
int lightSensor3 = 0;
int lightSensor4 = 0;
int lightSensor5 = 0;
int lightSensor6 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 14;
const int Switch2 = 15;
const int Switch3 = 16;
const int Switch4 = 17;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

const int VoiceD1 = 7;
const int VoiceD2 = 8;
const int VoiceD3 = 9;

//
// AY SYTHESIZER CONSTANTS
//
const int AYBDIR = 2;  // set up names for some Arduino pins
const int AYBC1 = 4;
const int AYBC2 = 3;

const int AYFineTuneA = 0;  // AY Synth Control Registers
const int AYFineTuneB = 2;
const int AYFineTuneC = 4;
const int AYCourseTuneA = 1;
const int AYCourseTuneB = 3;
const int AYCourseTuneC = 5;
const int AYNoisePeriod = 6;
const int AYEnable = 7;
const int AYAmpA = 8;
const int AYAmpB = 9;
const int AYAmpC = 10;
const int AYEnvFineTune = 11;
const int AYEnvCourseTune = 12;
const int AYEnvShape = 13;

int switchx = 0;

//
//SID SYNTHESIZER CONSTANTS
//
const int SIDCS = 5;
const int SIDRW = 6;

//SID read register values

int potX = 0;
int potY = 0;
int osc3_rand = 0;
int env3 = 0;

int addr[4] = {0, 0, 7, 14};  //voice register address offsets 1, 2, 3
int v = 0;

// voice register values (Use voice = 1, 2, or 3.  Don't use zero)

int Attack[4] = {0, 0, 0, 0};      // (0 to 15)
int Decay[4] = {0, 0, 0, 0};       // (0 to 15)
int Sustainx[4] = {0, 15, 15, 15};  // (0 to 15)
int Release[4] = {0, 0, 0, 0};     // (0 to 15)
int FreqLo[4] = {0, 0, 0, 0};      // (0 to 255)
int FreqHi[4] = {0, 16, 16, 16};   // (0 to 255)
int PulseWLo[4] = {0, 0, 0, 0};    // (0 to 255)
int PulseWHi[4] = {0, 8, 8, 8};    // (0 to 15)
int Waveshape[4] = {0, 0, 0, 0};   // Load with the bit values below

// bit values for the voice Waveshape (Control) register

const int NOISE = 128;
const int PULSE = 64;
const int SAWTOOTH = 32;
const int TRIANGLE = 16;
const int TEST = 8;
const int RINGMOD = 4;
const int SYNC = 2;

// bit values for filt of ldResFilt, add the ones you want, zero for none

const int FILTEX = 8;  // send external signal through the Filter
const int FILT3 = 4;   // send Voice 3 through the Filter
const int FILT2 = 2;   // send Voice 2 through the Filter
const int FILT1 = 1;   // send Voice 3 through the Filter

int filt = 0;

// bit values for mode of ldModeVol, add the ones you want, zero for none
  
const int OFF3 = 128;  // no Voice3 in the output (when used in ring modulation)
const int HP = 64;     // set Filter tos High Pass
const int BP = 32;     // set Filter to BandPass
const int LP = 16;     // set Filter to LowPass
bool hp = 0;
bool bp = 0;
bool lp = 0;
int res = 0;

const int LED = 20;

bool sidVoice1_ON = 0;
bool sidVoice2_ON = 0;

//SID frequency values for equal temperment A440 MIDI NoteON commands

byte SIDMidiNoteHi[128] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 
  2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 
  4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 8, 
  8, 9, 9, 10, 10, 11, 12, 12, 13, 14, 15, 16, 
  17, 18, 19, 20, 21, 22, 24, 25, 27, 28, 30, 32, 
  34, 36, 38, 40, 43, 45, 48, 51, 54, 57, 61, 64, 
  68, 72, 76, 81, 86, 91, 96, 102, 108, 115, 122, 129, 
  137, 145, 153, 163, 172, 183, 193, 205, 217, 230, 244, 244, 
  244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 
  244, 244, 244, 244, 244, 244, 244, 244
};

byte SIDMidiNoteLow[128] = {
  137, 145, 154, 163, 173, 183, 194, 206, 218, 231, 244, 3, 
  18, 35, 52, 70, 90, 110, 132, 155, 180, 205, 233, 6, 
  37, 69, 104, 141, 179, 220, 8, 54, 103, 155, 210, 12, 
  73, 139, 208, 25, 103, 185, 16, 108, 206, 54, 163, 24, 
  147, 21, 160, 50, 205, 114, 32, 217, 156, 107, 71, 47, 
  38, 43, 63, 100, 155, 228, 64, 177, 56, 215, 141, 95, 
  75, 86, 127, 200, 53, 199, 128, 98, 112, 173, 27, 189, 
  151, 171, 253, 145, 107, 142, 255, 196, 225, 90, 54, 122, 
  45, 86, 250, 34, 213, 28, 255, 137, 194, 180, 108, 108, 
  108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 108, 
  108, 108, 108, 108, 108, 108, 108, 108
};
 
//AY frequency values for equal temperment A440 MIDI NoteON commands

byte AYMidiNoteHi[128] = {
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 
  14, 14, 13, 12, 11, 11, 10, 9, 9, 8, 8, 7, 
  7, 7, 6, 6, 5, 5, 5, 4, 4, 4, 4, 3, 
  3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 1, 
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0, 0, 0, 0, 0, 0, 0, 0
};

byte AYMidiNoteLow[128] = {
  211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 211, 
  239, 25, 78, 141, 218, 47, 143, 247, 104, 225, 97, 233, 
  119, 12, 167, 71, 237, 152, 71, 252, 180, 112, 49, 244, 
  188, 134, 83, 36, 246, 204, 164, 126, 90, 56, 24, 250, 
  222, 195, 170, 146, 123, 102, 82, 63, 45, 28, 12, 253, 
  239, 225, 213, 201, 190, 179, 169, 159, 150, 142, 134, 127, 
  119, 113, 106, 100, 95, 89, 84, 80, 75, 71, 67, 63, 
  60, 56, 53, 50, 47, 45, 42, 40, 38, 36, 34, 32, 
  30, 28, 27, 25, 24, 22, 21, 20, 19, 18, 17, 16, 
  15, 14, 13, 13, 12, 11, 11, 10, 9, 9, 8, 8, 
  7, 7, 7, 6, 6, 6, 5, 5
};

byte eventNotes[255] = {0};  //holds recorded Midi Input NoteOn
unsigned long eventTimes[255] = {0};  //holds recorded times of Notes
byte eventVelocity[255] = {0};  // holds recorded note velocities
byte eventVoice[255] = {0};   // holds recorded voice assignment of notes

unsigned long eventTime = 0;
unsigned long startTime = 0; // created by timestamp()
int currentTime = 0;

int  eventIndex = 0;  // holds position within the 4 record arrays
bool record = 0;
bool playback = 0;
bool triggerRecord = 0;
bool triggerPlayback = 0;

int taptop = 1;

//current note on's for AY voices A, B, and C.  Use note value 0 for "not on". 
byte CurrentNoteOn[3] = {0, 0, 0}; 
byte VoiceOn[3] = {0, 0, 0};  // reflects voice off and on from MIDI NoteON/Off

byte Mode[3] = { 0, 0, 0 };  // sets up AY volume by 4-bit Amp, or Envelopes
 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

//MIDI Callback Handle references here
//MIDI.begin(MIDI_CHANNEL_OMNI);

  MIDI.setHandleNoteOn(myHandleNoteOn); //for Callback MIDI In 
  MIDI.setHandleNoteOff(myHandleNoteOff); //for Callback MIDI In 
  MIDI.begin(MIDI_CHANNEL_OMNI);
  
pinMode(LED, OUTPUT);

pinMode(SIDRW, OUTPUT);
digitalWrite(SIDRW, LOW);    // High for Read, Low for Write
pinMode(SIDCS, OUTPUT);
digitalWrite(SIDCS, HIGH); //Chip Select active low,Read or Write to register

pinMode(AYBDIR, OUTPUT);
digitalWrite(AYBDIR, LOW);
pinMode(AYBC1, OUTPUT);
digitalWrite(AYBC1, LOW);
pinMode(AYBC2, OUTPUT);
digitalWrite(AYBC2, LOW);

pinMode(VoiceD1, OUTPUT);
digitalWrite(VoiceD1, LOW);
pinMode(VoiceD2, OUTPUT);
digitalWrite(VoiceD2, LOW);
pinMode(VoiceD3, OUTPUT);
digitalWrite(VoiceD3, LOW);


pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistors
digitalWrite(Switch1, HIGH);
pinMode(Switch2, INPUT);
digitalWrite(Switch2, HIGH);
pinMode(Switch3, INPUT);
digitalWrite(Switch3, HIGH);
pinMode(Switch4, INPUT);
digitalWrite(Switch4, HIGH);

DDRA = B11111111;  // outputs
DDRB = B11111111;
DDRC = B11111111;

AYldEnable(B111000);  //Enable only tones (low enable)
                    
// ~~~~~~~~~~~~~~Setup Synth values~~~~~~~~~~~~~~~~~~~~

resetSID();

Attack[1] = 12;
Decay[1] = 8;
ldEnvAD(1);
Sustainx[1] = 8;
Release[1] = 12;
ldEnvSR(1);
Waveshape[1] = SAWTOOTH;

Attack[2] = 10;
Decay[2] = 4;
ldEnvAD(2);
Sustainx[2] = 10;
Release[2] = 10;
ldEnvSR(2);
Waveshape[2] = SAWTOOTH;

Attack[3] = 0;
Decay[3] = 0;
ldEnvAD(3);
Sustainx[3] = 15;
Release[3] = 8;
ldEnvSR(3);
Waveshape[3] = TRIANGLE;

ldFiltRes(0, 8);
ldModeVol(OFF3 + LP, 15);

digitalWrite(LED, HIGH);
          //---SID Test -----
                   FreqHi[1]=SIDMidiNoteHi[50]; 
                   ldFreqHi(1);
                   FreqLo[1]=SIDMidiNoteLow[50];
                   ldFreqLo(1);              
                   ldGate(1, 1);  
                   delay(300);
                   FreqHi[2]=SIDMidiNoteHi[60]; 
                   ldFreqHi(2);
                   FreqLo[2]=SIDMidiNoteLow[60];
                   ldFreqLo(2);
                   ldGate(2, 1);    
                   delay(1000);
                    ldGate(1, 0);  
                    ldGate(2, 0); 
                    delay(500); 

                                        
          // ---AY Test ---          
                    playEvent(40, 70, 0); 
                    delay(100);
                    playEvent(60, 70, 1); 
                    delay(100);
                    playEvent(80, 70, 2); 
                    delay(100);                   
                    playEvent(40, 0, 0);
                    playEvent(40, 0, 1);
                    playEvent(40, 0, 2);
                       
digitalWrite(LED, LOW);
 
                    
                     
 //Serial.begin(9600);                                               
                   
} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

    loadSensors();
    //readRegisters();
    ldFCHi(slider6 >>5);
    
    
    tone(VoiceD1, (frontPot >> 1));  // set frequency of Voice D
    
    Waveshape[1] = TRIANGLE + (!switch3 * RINGMOD);
      if (!switch4) { Waveshape[2] = TRIANGLE + SYNC; } else { Waveshape[2] = PULSE; }
    
    filt = (!switch1 * FILT1) + (!switch2 * FILT2) + FILTEX;
              ldFiltRes(filt, 8);  
                                           
// On MIDI.read() MIDI class will call Callback functions.
// User created callback function myHandleNoteOn() and myHandleNoteOff() at end
// MIDI.setHandleNoteOn(myHandleNoteOn), MIDI.setHandleNoteOff(myHandleNoteOff) in setup() 

//---------------------- Set SID Voices -------------------

  FreqHi[1] = (slider4 >> 3) + (lightSensor4 >> 5);
  ldFreqHi(1);
  FreqLo[1]= lightSensor4 >> 2;
  ldFreqLo(3);
  
  FreqHi[2] = (slider5 >> 3) + (lightSensor5 >> 5);
  ldFreqHi(2);
  FreqLo[2]= lightSensor5 >> 2;
  ldFreqLo(2);
  
  FreqHi[3] = (slider3 >> 3) + (lightSensor3 >> 5);
  ldFreqHi(3);
  FreqLo[3]= lightSensor3 >> 2;
  ldFreqLo(3);

  PulseWHi[2] = slider6 >> 8;
  ldPulseWHi(2);
  PulseWLo[2] = (slider6 & 255) ;
  ldPulseWLo(2);

if ((lightSensor1 > 100) && (sidVoice1_ON == 0)) {
    //Serial.print(lightSensor1); Serial.println(" Voice1 On"); 
    ldGate(1, 1); sidVoice1_ON = 1; 
  }

else if ((lightSensor1 < 100) &&  (sidVoice1_ON == 1)) {
    //Serial.print(lightSensor1); Serial.println(" Voice1 Off"); 
    ldGate(1, 0); sidVoice1_ON = 0; } 

 if ((lightSensor2 > 100) && (sidVoice2_ON == 0)) {
    //Serial.print(lightSensor2); Serial.println(" Voice2 On"); 
    ldGate(2, 1); sidVoice2_ON = 1; 
  }
    
  else if ((lightSensor2 < 100) &&  (sidVoice2_ON == 1)) {
    //Serial.print(lightSensor2); Serial.println(" Voice2 Off"); 
    ldGate(2, 0); sidVoice2_ON = 0; }
     

//
//--------------Use SoftPot taps to start and stop record or playback -------------
//

if ((softPot > 400) && (softPot < 600)){     //Middle of softPot -- start Playback
    triggerRecord = 0; 
    triggerPlayback = 1;
    delay(500); }  
else if ((softPot > 50) && (softPot < 200)){     //Bottom of softPot  -- start Record
    triggerPlayback = 0;
    triggerRecord = 1; 
    delay(500); } 

                  if (triggerRecord && !record){  //start record
                      triggerRecord = 0;
                      playback = 0;
                      record = 1;
                      digitalWrite(LED, HIGH);
                      eventIndex = 0;
                                for (int i=0; i < 255; i++){
                                    eventNotes[i] = 255;
                                    eventTimes[i] = 0;
                                }
                       timestamp();
                       
                  }
                  
                  else if (triggerPlayback && !playback){  //start playback
                      triggerPlayback = 0;
                      record = 0;
                      digitalWrite(LED, HIGH);
                      playback = 1;
                      eventIndex = 0;
                      timestamp();                                                                 
                  }
                  
                  else if (triggerRecord && record){  //stop record
                      triggerRecord = 0;
                      playback = 0;
                      record = 0;
                      digitalWrite(LED, LOW);  
                  }
                  
                  else if (triggerPlayback && playback){  //stop playback
                      triggerPlayback = 0;
                      record = 0;
                      digitalWrite(LED, LOW);
                      playback = 0;
                      AYldAmpA(0);
                      AYldAmpB(0);
                      AYldAmpC(0);
                  
                  }

//--------------------------------------------------------------------------------

                 MIDI.read();
//
//---------------Playback of Notes[] at Times []-----------------------------
//

      while (playback) {
       
           currentTime = dur();                    
           while (eventTimes[eventIndex] <= currentTime){            
           playEvent(eventNotes[eventIndex], eventVelocity[eventIndex], eventVoice[eventIndex]);
                        eventIndex = eventIndex + 1;
                        if (eventNotes[eventIndex] == 255){   // no more recorded notes                             
                              eventIndex = 0;              // rewind to beginning
                              timestamp();                              
                              break;
                        }  //  end of rewind 
           } // end of while              
                                break;                     
      } //end of while playback


} //End of Main Loop

//____________________________________________________
//                SID Basic Address and Data Functions
//____________________________________________________

void loadAddress(int address){
 PORTB = address;
}

void loadData(int data){ 
  PORTC = data;   
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);  
  digitalWrite(SIDCS, HIGH);
}

void resetSID(){
  for(int i=0; i<25; i++){
    loadAddress(i);
    loadData(0);
  } 
  ldModeVol(LP, 255);
  }

void readRegisters(){      //Collect values of all 4 SID readable registers
  DDRC = B00000000;        //Setup Data Lines as Inputs
  digitalWrite(SIDRW, HIGH);  // Setup Read/Write for a Data Read
  
  loadAddress(25);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  potX = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);
  
  loadAddress(28);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  env3 = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);

  loadAddress(27);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  osc3_rand = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);

  loadAddress(26);
  digitalWrite(SIDCS, LOW);
  delayMicroseconds(3);
  potY = PINC;
  delayMicroseconds(3);
  digitalWrite(SIDCS, HIGH);

  digitalWrite(SIDRW, LOW);  // Reset Read/Write to Data Write
  DDRC = B11111111;       // Reset Data Lines as Outputs
}

//____________________________________________________
//               SID Individual Control Register Load 
//____________________________________________________

  /*       ldFreqLo, ldFreqHi,        --voices 1, 2, 3   Frequency
           ldPulseWLo, ldPulseWHi,    --voices 1, 2, 3   Pulse Width
           ldGate,                    --voices 1, 2, 3   Gate the Envelope (+ Waveshape)
           ldEnvAD, ldEnvSR,          --voices 1, 2, 3   Envelope ADSR
           ldFCLo, ldFCHi, ldResFilt  --Filter Cutoff Frequency/Resonance
           ldModeVol                  --FilterType/OutputVolume
*/

void ldFreqLo(int voice){  //8-bit fine tune frequency -- FreqLo
  loadAddress(addr[voice]);
  loadData(FreqLo[voice] & 255);
}

void ldFreqHi(int voice){  //8-bit course tune frequency -- FreqHi
  loadAddress(addr[voice]+1);
  loadData(FreqHi[voice] & 255);
}

void ldPulseWLo(int voice){  //8-bit fine tune Pulse Width -- PulseWLo
  loadAddress(addr[voice]+2);
  loadData(PulseWLo[voice] & 255);
}

void ldPulseWHi(int voice){  //4-bit course tune Pulse Width -- PulseWHi
  loadAddress(addr[voice]+3);
  loadData(PulseWHi[voice] & 15);
}

void ldGate(int voice, int x){  // Gates the ADSR Envelope (also loads Waveshape)
  
  loadAddress(addr[voice]+4);
  loadData(Waveshape[voice] + x);
}

void ldEnvAD(int voice){  //4-bit Attack Time, 4-bit Decay time -- Env Attack/Decay
  loadAddress(addr[voice]+5);
  int x = ((Attack[voice] & 15) << 4) + (Decay[voice] & 15);
  loadData(x);
}


void ldEnvSR(int voice){  //4-bit Sustain Level, 4-bit Release time -- Env Sustain/Release
  loadAddress(addr[voice]+6);
  int x = ((Sustainx[voice] & 15) << 4) + (Release[voice] & 15);
  loadData(x);
}

void ldFCLo(int data){  //3-bit fine tune Filter Cutoff Frequency
  loadAddress(21);
  loadData(data & 7);
}

void ldFCHi(int data){  //8-bit course tune Filter Cutoff Frequency
  loadAddress(22);
  loadData(data & 255);
}

void ldFiltRes(int filt, int res){   //FILTEX/FILT3/FILT2/FILT1, 4-bit Filter Resonance, 
  loadAddress(23);
  int x = ((res & 15) << 4) + (filt & 15);
  loadData(x);
}

void ldModeVol(int mode, int vol){   //Filter Type 3OFF/HP/BP/LP, 4-bit Output Volume
  loadAddress(24);
  loadData((vol & 15) + (mode & B11110000));
}



void loadSensors(){      // load all current sensor values
      slider1 =   analogRead(Slider1);
      slider2 =   analogRead(Slider2);
      slider3 =   analogRead(Slider3);
      slider4 =   analogRead(Slider4);
      slider5 =   analogRead(Slider5);
      slider6 =   analogRead(Slider6);
      softPot =   analogRead(SoftPot);
      frontPot =  analogRead(FrontPot);
      lightSensor1 =   analogRead(LightSensor1)>>2;
      lightSensor2 =   analogRead(LightSensor2)>>2;
      lightSensor3 =   analogRead(LightSensor3)>>2;
      lightSensor4 =   analogRead(LightSensor4)>>2;
      lightSensor5 =   analogRead(LightSensor5)>>2;
      lightSensor6 =   analogRead(LightSensor6)>>2;
      switch1 = digitalRead(Switch1);
      switch2 = digitalRead(Switch2);
      switch3 = digitalRead(Switch3);
      switch4 = digitalRead(Switch4);     
}
 
//  _________________________________________________________________
//                AY Address and Data Load Functions
//  _________________________________________________________________

void AYloadAddress(int address){
  PORTA = (address & B1111);
  delayMicroseconds(2);
  
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
 
  digitalWrite(AYBDIR, LOW);
}

void AYloadData(int data){
    
  PORTA = data;

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}

void AYloadDataShort(int data){
  PORTA = (data & B111111);

  delayMicroseconds(2);
  digitalWrite(AYBC2, HIGH);
  digitalWrite(AYBDIR, HIGH);
  delayMicroseconds(2);
  digitalWrite(AYBDIR, LOW);
  digitalWrite(AYBC2, LOW);
}


//  ____________________________________________________________________
//                AY General Control Register Load
//  ____________________________________________________________________

void AYldSynth(int address, int data){  // Load 4-bit Control Register Address then 8-bit data
  AYloadAddress(address);
  AYloadData(data);
}

//  ______________________________________________________________________
//                AY Individual Control Register Load 
//  _______________________________________________________________________


void AYldFineTuneA(int data){  //8-bit fine tune A
  AYloadAddress(AYFineTuneA);
  AYloadData(data);
}

void AYldFineTuneB(int data){  //8-bit fine tune B
  AYloadAddress(AYFineTuneB);
  AYloadData(data);
}

void AYldFineTuneC(int data){  //8-bit fine tune C
  AYloadAddress(AYFineTuneC);
  AYloadData(data);
}

void AYldCourseTuneA(int data){  //4-bit course tune A
  AYloadAddress(AYCourseTuneA);
  AYloadDataShort(data);
}

void AYldCourseTuneB(int data){  //4-bit course tune B
  AYloadAddress(AYCourseTuneB);
  AYloadDataShort(data);
}

void AYldCourseTuneC(int data){  //4-bit course tune C
  AYloadAddress(AYCourseTuneC);
  AYloadDataShort(data);
}

void AYldNoisePeriod(int data){  //5-bit noise period tune
  AYloadAddress(AYNoisePeriod);
  AYloadDataShort(data);
}

void AYldEnable(int data){  //Low 1-bit enable, Noise C/B/A Tone C/B/A
  AYloadAddress(AYEnable);
  AYloadDataShort(data);
}

void AYldAmpA(int amp){  //4-bit amplitude of A if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpA);
  AYloadDataShort(amp);
}

void AYldAmpB(int amp){  //4-bit amplitude of B if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpB);
  AYloadDataShort(amp);
}

void AYldAmpC(int amp){  //4-bit amplitude of C if 0-15, else use Env if 16 (mode bit high)
  AYloadAddress(AYAmpC);
  AYloadDataShort(amp);
}

void AYldEnvFineTune(int data){  //8-bit Envelope Period fine tune
  AYloadAddress(AYEnvFineTune);
  AYloadData(data);
}

void AYldEnvCourseTune(int data){  //8-bit Envelope Period course tune
  AYloadAddress(AYEnvCourseTune);
  AYloadData(data);
}

void AYldEnvShape(int data){  //4-bit Envelope Shape. Continue/Attack/Alternate/Hold
  AYloadAddress(AYEnvShape);
  AYloadDataShort(data);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      Callback MIDI_In Handles
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// user created Callback Function for MIDI Input Test

 void myHandleNoteOn(byte channel, byte note, byte velocity){
  
    for (int x = 0; x < 3; x ++){    // search through the 3 AY voices

    if (CurrentNoteOn[x] == 0){      // this AY voice is available
                        
                   playEvent(note, velocity, x);
                  //  AYldEnvShape(!switch4 + (!switch3 * 2) + (!switch2 * 4) + (!switch1 * 8));               
                   if (velocity == 0) {CurrentNoteOn[x] = 0; } 
                   else {CurrentNoteOn[x] = note; }  
                   if (record){ loadEventArrays(note, velocity, x); }                                                                             
                 break;  //  break out of voice search loop   
                                              
     }  // end of Note On check

     
}  // end of for loop
}  // end of Handle
 
 void myHandleNoteOff(byte channel, byte note, byte velocity){
 for (int x = 0; x < 3; x ++){          // search through the 3 AY voices

    if (CurrentNoteOn[x] == note){      // which voice is playing the note to turn off?

                 switch (x) {           
                 case 0:  
                   AYldAmpA(0);                    
                   CurrentNoteOn[x] = 0;
                   if (record){ loadEventArrays(note, 0, 0); }      
                   break;                                 
                case 1:
                   AYldAmpB(0);                    
                   CurrentNoteOn[x] = 0; 
                   if (record){ loadEventArrays(note, 0, 1); }          
                   break;                                 
                case 2:
                  AYldAmpC(0);                    
                   CurrentNoteOn[x] = 0;
                   if (record){ loadEventArrays(note, 0, 2); }            
                   break;       
                 }  // end of switch 
                                                                           
     }  // end of Note check

     
}  // end of for loop
}  //end of Handle

void loadEventArrays(int note, int velocity, int voice){
  eventTimes[eventIndex] = dur();
  eventNotes[eventIndex] = note;
  eventVelocity[eventIndex] = velocity;
  eventVoice[eventIndex] = voice;
  eventIndex = eventIndex + 1;
}

void playEvent(int n, int v, int AYvoice){
        switch (AYvoice) {           
                 case 0:                   
                   AYldCourseTuneA(AYMidiNoteHi[n]);
                   AYldFineTuneA(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = 15;}
                   AYldAmpA(v + Mode[0]);                   
                   break;                                 
                case 1:
                   AYldCourseTuneB(AYMidiNoteHi[n]);
                   AYldFineTuneB(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = 15;}
                   AYldAmpB(v + Mode[1]);                     
                   break;                                 
                case 2:
                   AYldCourseTuneC(AYMidiNoteHi[n]);
                   AYldFineTuneC(AYMidiNoteLow[n] - (slider2 >> 3));
                   if(v > 0){v = 15;}
                   AYldAmpC(v + Mode[2]);                        
                   break;       
                 }  // end of switch 
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//              TIMER  Loop Functions
//  ______________________________________________________________________________

void timestamp() {startTime = millis(); };
// store current time from the running clock millis()

unsigned long dur(){
  return ((millis() + (slider1 * 2)) - startTime);
  //return (millis() - startTime);
}
// returns the current time minus the last store timestamp

void waitTill(unsigned long msec) {
  while (dur() < msec) {};
}
//wait till the time duration from timestamp equals the given time in msec
