
/*
 * Euro Mega Control
 * A red case with Euro size cards for interfacing with Analog Synths
 * Contains: 6 Pulse Inputs, 6 Pulse Outputs, 6 Control Voltage Inputs 
 *           (with Envelope Followers), 6 Control Voltage Outputs
 *           (RC filtered PWM), MIDI IN, MIDI OUT, 8-bit DAC Out,
 *           Diode Gate.
 * 
 */
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 #include <MIDI.h>  // version 4.x.x
 MIDI_CREATE_INSTANCE(HardwareSerial, Serial1, MIDI); 

// User created MIDI Callback functions here

 const int  MIDI_TX = 18;  //on SERIAL1
  const int MIDI_RX = 19;  //on SERIAL1
  
 const int PULSE_IN1 = 2;  //Interrupt 4
 const int PULSE_IN2 = 3;  //Interrupt 5
 const int PULSE_IN3 = 16;
 const int PULSE_IN4 = 17;
 const int PULSE_IN5 = 20; //Interrupt 0
 const int PULSE_IN6 = 21; //Interrupt 1

 const int PULSE_OUT1 = 9;
 const int PULSE_OUT2 = 10;
 const int PULSE_OUT3 = 12;
 const int PULSE_OUT4 = 13;
 const int PULSE_OUT5 = 14;
 const int PULSE_OUT6 = 15;

 const int CV_IN1 = 8;  //Analog inputs for analogRead();
 const int CV_IN2 = 9;
 const int CV_IN3 = 10;
 const int CV_IN4 = 11;
 const int CV_IN5 = 12;
 const int CV_IN6 = 13;
 const int SIGNAL_IN1 = 14;  //2 Signal Inputs Jacks, either side of Reset Button
 const int SIGNAL_IN2 = 15;  //Biased at 2.5v for 0-5v Analog Inputs

 const int CV_OUT1 = 4;  //Timer0
 const int CV_OUT2 = 5;  //Timer3
 const int CV_OUT3 = 6;  //Timer4
 const int CV_OUT4 = 7;  //Timer4
 const int CV_OUT5 = 8;  //Timer4
 const int CV_OUT6 = 11; //Timer

 const int DAC_WR = 37;  //AD7224 DAC Write pulse (active low)
 // DAC inputs on A0 through A7, register F

 const int GATE_IN1 = 39;  //Two Arduino Inputs to Diode Gate
 const int GATE_IN2 = 38;  //3 more external Gate inputs surround the Reset Button

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

  //Serial.begin(9600);

  //MIDI Callback Handle references here
  MIDI.begin(MIDI_CHANNEL_OMNI);
  
  pinMode(PULSE_IN1, INPUT_PULLUP);
  pinMode(PULSE_IN2, INPUT_PULLUP);
  pinMode(PULSE_IN3, INPUT_PULLUP);
  pinMode(PULSE_IN4, INPUT_PULLUP);
  pinMode(PULSE_IN5, INPUT_PULLUP);
  pinMode(PULSE_IN6, INPUT_PULLUP);

  pinMode(PULSE_OUT1, OUTPUT);
  pinMode(PULSE_OUT2, OUTPUT);
  pinMode(PULSE_OUT3, OUTPUT);
  pinMode(PULSE_OUT4, OUTPUT);
  pinMode(PULSE_OUT5, OUTPUT);
  pinMode(PULSE_OUT6, OUTPUT);

  digitalWrite(PULSE_OUT1, HIGH); //Final Jack Outputs are inverted
  digitalWrite(PULSE_OUT2, HIGH); //LEDs are inverted, Low jack output is On
  digitalWrite(PULSE_OUT3, HIGH);
  digitalWrite(PULSE_OUT4, HIGH);
  digitalWrite(PULSE_OUT5, HIGH);
  digitalWrite(PULSE_OUT6, HIGH);

  pinMode(A0, OUTPUT);  //8-bit DAC data inputs on Port F
  pinMode(A1, OUTPUT);
  pinMode(A2, OUTPUT);
  pinMode(A3, OUTPUT);
  pinMode(A4, OUTPUT);
  pinMode(A5, OUTPUT);
  pinMode(A6, OUTPUT);
  pinMode(A7, OUTPUT);
  
  pinMode(DAC_WR, OUTPUT);    //DAC write pulse, active low
  digitalWrite(DAC_WR, HIGH); //normally high

  pinMode(GATE_IN1, OUTPUT);  //Diode OR Gate inputs
  pinMode(GATE_IN2, OUTPUT);
  
  digitalWrite(GATE_IN1, LOW);  //a HIGH closes the gate to any other input signal
  digitalWrite(GATE_IN2, LOW);  
 

} // end of setup()

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     LOOP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {


} // end of loop()
