


// Arduino Zero / Feather M0 I2S audio tone generation example.
// Author: Tony DiCola
//
// Connect an I2S DAC or amp (like the UDA1334A) to the Arduino Zero
// and play back simple sine.  Using Adafruit_ZeroI2S library.
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include "Adafruit_ZeroI2S.h"

#define SAMPLERATE_HZ 44100// 22.7usec --> 44100, works also at 48000, 88200 (not 96000)
#define AMPLITUDE     ((1<<30)-1)  //32, 24, 16, 8 
#define WAV_SIZE      512  

// Define the frequency of music notes 
#define C4_HZ      261.63
#define D4_HZ      293.66

// Store basic waveform in memory.
   int32_t sine[WAV_SIZE]     = {0};

// Create I2S audio transmitter object.
Adafruit_ZeroI2S i2s;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void generateSine(int32_t amplitude, int32_t* buffer, uint16_t length) {
  for (int i=0; i<length; ++i) {
    buffer[i] = int32_t(float(amplitude)*sin(2.0*PI*(1.0/length)*i));
  }
} //End generateSine

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {
  
  // Configure serial port.  

//              Serial.begin(500000);
//              while (!Serial) { delay(10); }  //waits for you to open Serial Monitor
//              Serial.println("Zero I2S Audio Tone Generator");

  // Initialize the I2S transmitter.
    if (!i2s.begin(I2S_32_BIT, SAMPLERATE_HZ)) {  //only works with 32_BIT ??
    Serial.println("Failed to initialize I2S");
    while (1); //do nothing if failed
  }
  i2s.enableTx();

  // Generate waveforms.
  generateSine(AMPLITUDE, sine, WAV_SIZE);
 
}   //End setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

  uint16_t pos = 0;  //integer position in wave table
  float posx; //float calculated position in wave table  
  int32_t sample = 0;
  
  // set output frequency by accessing wavetable at different intervals or "delta"
  float delta = (C4_HZ * WAV_SIZE)/float(SAMPLERATE_HZ); //wavetable sample interval
  
  int timeIn; //for finding sample rate

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

while(1){

//                     timeIn = micros(); //for printing sample rate time
   
      posx += delta; 
      if (posx > WAV_SIZE){ posx = posx - WAV_SIZE; }      
      pos = uint32_t(posx); 
      
      sample = sine[pos];
//                     Serial.println(sample); //Use Serial Plotter to see wave
      i2s.write(sample, sample); 

//                     timeIn = micros() - timeIn;
//                     Serial.println(timeIn);  //print sample rate time in microsec

  }   //End while
}   //End loop

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
