
//
// Connect an I2S DAC or amp (like the UDA1334A) to the Arduino Zero
// and play back simple sine.  Using I2S.h library.

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include "I2S.h"

#define AMPLITUDE     ((1<<15)-1)  //32, 24, 16, 8 
#define WAV_SIZE      1024 
const int sampleRate = 32000; //sample rate for I2S.h 

// Define the frequency of music notes 
#define C4_HZ      261.63
#define D4_HZ      293.66

// Store basic waveform in memory.
short sine[WAV_SIZE]     = {0};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void generateSine(short amplitude, short* buffer, short length) {
  for (int i=0; i<length; ++i) {
    buffer[i] = short(float(amplitude)*sin(2.0*PI*(1.0/length)*i));
  }
} //End generateSine
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {
  
  // Configure serial port.  

//              Serial.begin(500000);
//              while (!Serial) { delay(10); }  //waits for you to open Serial Monitor
//              Serial.println("Zero I2S Audio Tone Generator");

   // start I2S at the sample rate with 16-bit wide sample
  if (!I2S.begin(I2S_PHILIPS_MODE, sampleRate, 16)) {
    Serial.println("Failed to initialize I2S");
    while (1); //do nothing if failed
  }

  // Generate waveforms.
  generateSine(AMPLITUDE, sine, WAV_SIZE);
 
}   //End setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

  uint16_t pos = 0;  //integer position in wave table
  float posx;        //float calculated position in wave table  
  short sample = 0;  //samples from wave table
  
  // set output frequency by accessing wavetable at different intervals or "delta"
  float delta = (C4_HZ * WAV_SIZE)/float(sampleRate); //wavetable sample interval
  
  int timeIn; //for finding sample rate

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

while(1){

//                                 timeIn = micros(); //for printing sample rate time
   
      posx += delta; 
      if (posx > WAV_SIZE){ posx = posx - WAV_SIZE; }      
      pos = uint32_t(posx); 
      
      sample = sine[pos];
//                         Serial.println(sample); //Use Serial Plotter to see wave
        I2S.write(sample);
        I2S.write(sample);

//                         timeIn = micros() - timeIn;
//                         Serial.println(timeIn);  //print sample rate time in microseco

  }   //End while
}   //End loop

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
