
/* 
                  
                ADC1 to DAC0 with hard and soft clipping
                
Mathmatically distort samples from a live ADC input before 
sending out to DAC1334 using the Adafruit I2S Library.

If switch1 is down, hard clip the signal at levels set by slider1.
If switch2 is down, soft clip the signal, slider2 set level the clipping starts,
                    slider4 sets amount of clip.

*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include "I2S.h"  //library for 1334 DAC board
#define SAMPLE_RATE 8000 

// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right

int slider1 = 0;  // ADC 12 bit  zero to 4096
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

//   Serial.begin(500000);  //used only for testing

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);

// start I2S at the sample rate with 16-bits per sample
  if (!I2S.begin(I2S_PHILIPS_MODE, SAMPLE_RATE, 16)) {
    Serial.println("Failed to initialize I2S");
    while (1); //do nothing if failed
  }

// set up speed of ADCs

ADC->CTRLB.reg = ADC_CTRLB_PRESCALER_DIV32 |  //Divde 48Khz GCLK by 32 for ADC
                 ADC_CTRLB_RESSEL_12BIT;       //Set ADC resolution to 12 bits
while(ADC->STATUS.bit.SYNCBUSY);              // Wait for these changes to sync

//Sampling Time Length SAMPLEN (normally 63) allows time for ADC capacitor to charge
ADC->SAMPCTRL.reg = ADC_SAMPCTRL_SAMPLEN(16);  //Set Sampling Time Length to 16

analogReadResolution(12);  //sample manipulations are done at higher resolution
analogWriteResolution(10); //highest resolution of MKRZero DAC


}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {  

//static signed int sample;
int16_t sample ;
static int squish = 7;  //squish factor 
int timeIn;


while(1){  // inner loop for higher sample rate

  sample = analogRead(A1) - 2048;  //make audio bipolar, +/- 2048, with 12 bit resolution
  //any multiply or divide operations must be done on bipolar signals with zero offsets

 

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Hard Fuzz ~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  if(digitalRead(SWITCH1)){  //simple fuzz, clip off top and bottom of waveform
    
         slider1 = (analogRead(SLIDER1) >> 2) + 20;   // slider, 20 to 1024
           if (sample > slider1){ sample = slider1; } //clip off top of waveform
           else if (sample < -slider1){ sample = -slider1; }  //chop off bottom of waveform
           // else middle range of waveform unaltered
           
  }  //End of SWITCH
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


  
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Soft Fuzz ~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  if(digitalRead(SWITCH2)){  //softer clip, squish top and bottom of waveform

    squish =  (analogRead(SLIDER4) >> 6) + 5;
    slider2 = (analogRead(SLIDER2) >> 2) + 20;   // slider, 20 to 1024
    
           if (sample > slider2){ 
            sample = slider2 + ((sample - slider2) / squish); //squish top of waveform
            } 
           else if (sample < -slider2){ 
            sample = -slider2 - ((-slider2 - sample) / squish); //squish bottom of waveform
            }  
           // else middle range of waveform unaltered
           
  }  //End of SWITCH
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

 sample = sample << 4; // 12-bit to 16-bit
 
 I2S.write(sample);  // write twice for left and right outputs
 I2S.write(sample);
  
// Serial.println(sample);  //use Serial Plotter to see output waveform, use low freq inputs
 
} //end of while 
} //End of loop


//````````````````````````````````````````````````````````````
