
// Connect an I2S DAC or amp (like the UDA1334A) to the Arduino Zero
// and play back from ADC A1.  Using I2S.h library.

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include "I2S.h"
const int sampleRate = 32000; //sample rate for I2S.h 

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {
  
// Configure serial port.  
 //                      Serial.begin(500000);
 //                      while (!Serial) { delay(10); } //waits for you to open Serial Monitor
 //                      Serial.println("Zero I2S Audio Tone Generator");

// start I2S at the sample rate with 16-bits per sample
  if (!I2S.begin(I2S_PHILIPS_MODE, sampleRate, 16)) {
    Serial.println("Failed to initialize I2S");
    while (1); //do nothing if failed
  }

// set up speed of ADCs

  ADC->CTRLB.reg = ADC_CTRLB_PRESCALER_DIV32 |  //Divde 48Khz GCLK by 32 for ADC
                 ADC_CTRLB_RESSEL_12BIT;       //Set ADC resolution to 12 bits
  while(ADC->STATUS.bit.SYNCBUSY);              // Wait for these changes to sync

//Sampling Time Length SAMPLEN (normally 63) allows time for ADC capacitor to charge
  ADC->SAMPCTRL.reg = ADC_SAMPCTRL_SAMPLEN(16);  //Set Sampling Time Length to 16
  
}   //End setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

  signed int sample = 0;  
  long timeIn; //for finding sample rate

while(1){
//                       timeIn = micros(); //for printing sample rate time

  sample = (analogRead(A1) - 2048) << 4;  //make bipolar, bring amp up from 12-bit to 16-bit

//                       Serial.println(sample);
  I2S.write(sample); // write twice for left and right outputs
  I2S.write(sample);
//                       timeIn = micros() - timeIn;
//                        Serial.println(timeIn);  //print sample rate time in microseconds

  }  //End while
}   //End loop

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
