
/* 
                  
                ADC1 to DAC0 with with Transform Array
                
Distort live ADC input with a transform array before sending out to DAC1334 using I2S library. 
The input signal is treated as bipolar with values -2048, through zero, to +2048
The same transfer array is applied to both positive and negative swings of the input signal.

A 2048 element array is created.  Each possible ADC input value from 0 to 2048 acts as the array index. The array elements act as alternative waveform values for each ADC waveform input value.

The array transform function is created manually by moving Slider3 through a count of 3 seconds.
Led1 gives a countdown of 3 one second blips . Led2 then turns on for a second count of 3 Led1 blips
during which 4096 values are recorded from the manual movement of Slider3.

Pushbutton3 is used to start the function record countdown process.

Then Output DAC Sample = array[ ADC Input Sample ]

Slider1 pans between the input waveform and the distorted output waveform.
The SampleRate can be raised to 16000 if this slow pan calculation is commented out.

Switches 1 & 2 turn on the Serial.print function for testing with the Serial Plotter
 
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include "I2S.h"  //library for 1334 DAC board
#define sampleRate 10000 
#define TDELAY 1300


// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right

int slider1 = 0;  // ADC 12 bit  zero to 4096
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED

unsigned int t = 0;
unsigned int x = 0;
boolean countdown = 0;
boolean countrecord = 0; 
boolean drawfunction = 0;
int blink3[6] = {171, 683, 853, 1365, 1536, 2047};
int tcase = 7;
int tfunction[2048];

signed int sample = 0;
signed int samplex = 0;
float pan = 0;


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

   Serial.begin(500000);  //used only for testing

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);
delay(250);
digitalWrite(LED1, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);


// set up speed of ADCs
ADC->CTRLB.reg = ADC_CTRLB_PRESCALER_DIV32 |  //Divde 48Khz GCLK by 32 for ADC
                 ADC_CTRLB_RESSEL_12BIT;       //Set ADC resolution to 12 bits
while(ADC->STATUS.bit.SYNCBUSY);              // Wait for these changes to sync

//Sampling Time Length SAMPLEN (normally 63) allows time for ADC capacitor to charge
ADC->SAMPCTRL.reg = ADC_SAMPCTRL_SAMPLEN(1);  //Set Sampling Time Length to 1

analogReadResolution(12);  //sample manipulations are done at higher resolution
analogWriteResolution(10); //highest resolution of MKRZero DAC



// start I2S at the sample rate with 16-bits per sample
  if (!I2S.begin(I2S_PHILIPS_MODE, sampleRate, 16)) {
    Serial.println("Failed to initialize I2S");
    while (1); //do nothing if failed
  }
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {  


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                    Creating Transform Curve
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  

 switch3 = digitalRead(SWITCH3);

 if (switch3 && !countdown){    //Start countdown and countrecord sequence
      countdown = 1;     
      t = 0;
      tcase = 1;
      digitalWrite(LED1, HIGH);
 }

switch (tcase) {  //countdown and countrecord states
 
  case 1:   //count1 led on
    if( t > blink3[0] ){
      //Serial.print(tcase); Serial.print("\t");  Serial.println(t);
      digitalWrite(LED1, LOW);
      tcase = 2;
    }
    break;
  case 2:   //count1 led off
    if( t > blink3[1] ){
      //Serial.print(tcase); Serial.print("\t");  Serial.println(t);
      digitalWrite(LED1, HIGH);
      tcase = 3;
    }
    break;
  case 3:   //count2 led on
    if( t > blink3[2] ){
      //Serial.print(tcase); Serial.print("\t");  Serial.println(t);
      digitalWrite(LED1, LOW);
      tcase = 4;
    }
      break;
  case 4:   //count2 led off
    if( t > blink3[3] ){
      //Serial.print(tcase); Serial.print("\t");  Serial.println(t);
      digitalWrite(LED1, HIGH);
      tcase = 5;
    }
      break;
  case 5:   //count3 led on
    if( t > blink3[4] ){
      //Serial.print(tcase); Serial.print("\t");  Serial.println(t);
      digitalWrite(LED1, LOW);
      tcase = 6;           
    }
     break;
  case 6:   //finish
    if( t > blink3[5] ){   //at end of countdown or countrecord, finish up
      //Serial.print(tcase); Serial.print("\t");  Serial.println(t);
    
      if (countdown){    //end the countdown and start the record
        countdown = 0;
        countrecord = 1;
        digitalWrite(LED1, HIGH);
        digitalWrite(LED2, HIGH);
        t = 0;
        tcase = 1;
     }
    
     else if (countrecord){    //end the record
        countrecord = 0;
        countdown = 0;
        digitalWrite(LED2, LOW);
        digitalWrite(LED1, LOW);
        tcase = 7; 
     }
    }
     break;
  case 7:  //do nothing till another start countdown
     break;   
  default:
     break;
}  //End of case


 if(countrecord){  //load Transfer function from Slider3 over a count of 3 led blips
  slider3 = analogRead(SLIDER3) ;  
  tfunction[t] = slider3 >> 1 ;
 }

 if(countrecord || countdown) {   //increment index in tfunction[] and wait about a second
    ++t; 
    delayMicroseconds(TDELAY);
 }


 switch1 = digitalRead(SWITCH1);  //use Serial Plotter to see transfer function in tfunction
 if(switch1){    
    for (int i = 0; i <= 2047; i++) {
      Serial.println(tfunction[i]);
      Serial.println("Min:0, Max:2047");   
      delay(1);
    }
  }  //End Switch1

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//             Sampling Transform
//  ______________________________________________________________________________


  samplex = analogRead(A1) - 2048;
  sample = samplex;  //keep samplex as the original input signal

  //for positive samples    
  if (sample >= 0) {  sample = tfunction[sample];  }  //apply transfer function 
  
  //for negative samples
  else {  
       sample = -sample;
       sample = tfunction[sample];  //apply transfer function 
       sample = -sample;    
  }  
  
  pan = analogRead(SLIDER1) ;
  pan = pan / 4095;  //pan is a float between 0 and 1
  
sample = (pan * sample) + ((1 - pan) * samplex);  //pan between input and distorted version

// Connect a sinewave to the A1 input and use the Serial Plotter to see the output waveform
                switch2 = digitalRead(SWITCH2);
                if (switch2){ Serial.println(sample); }                         
 
 sample = sample << 4;  //12-bit to 16-bit size
              

  I2S.write(sample);  // write twice for left and right outputs
  I2S.write(sample);

} //End of loop

//````````````````````````````````````````````````````````````
