
/* 
                  
                Test DAC0 and ADC1
                
Send output of ADC1 directly to DAC0.
Toggle LED2 pin on each transfer.
Read with Oscilliscope the speed.

*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 
// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right


int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch


boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;


#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED

int sample;
long timeIn;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

//    Serial.begin(500000);  //used only for printing samplerate times

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);

// Speed up the ADC Sampling Rate

ADC->CTRLB.reg = ADC_CTRLB_PRESCALER_DIV32 |  //Divde 48Khz GCLK by 32 for ADC
                 ADC_CTRLB_RESSEL_10BIT;       //Set ADC resolution to 10 bits
while(ADC->STATUS.bit.SYNCBUSY);              // Wait for these changes to sync
//Sampling Time Length SAMPLEN (normally 63) allows time for ADC capacitor to charge
ADC->SAMPCTRL.reg = ADC_SAMPCTRL_SAMPLEN(1);  //Set Sampling Time Length to 1

analogReadResolution(10);
analogWriteResolution(10);

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

//        timeIn = micros();

//lowers the sampling rate to increase delay, results in foldover frequencies
  if (digitalRead(SWITCH1)){ delayMicroseconds(analogRead(SLIDER1) >> 3); }

sample = analogRead(A1);
analogWrite(A0, sample);

//        timeIn = micros() - timeIn;
//        Serial.println(timeIn);  //print sample rate time in microseconds

} //End of Loop

//````````````````````````````````````````````````````````````
