
/* 
                  
                ADC1 to DAC0 with triangle modulation
                
Send output of ADC1 directly to DAC0, one sample each time through the main loop
Sampling frequency determined by loop time.

When Pushbutton1 is down, Slider1 changes frequency of modulation
When Pushbutton2 is down, Slider2 changes depth of modulation (and also frequency)

Thanks to "Arduino Music and Audio Projects" by Mike Cook
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 
// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right


int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch


boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;


#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED

int sample;
float mod = 0.5;
float increment = 0.0035 ;
float depthHI = 0.80;
float depthLO = 0.02;
int sampleIn, sampleOut;
int midPoint = 516;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

  delay(1000);

 //  Serial.begin(9600);  //turn on to see mod Waveform

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);

ADC->CTRLB.reg = ADC_CTRLB_PRESCALER_DIV512 |  //Divde 48Khz GCLK by 512 for ADC
                 ADC_CTRLB_RESSEL_10BIT;       //Set ADC resolution to 10 bits
while(ADC->STATUS.bit.SYNCBUSY);              // Wait for these changes to sync

//Sampling Time Length SAMPLEN (normally 63) allows time for ADC capacitor to charge
ADC->SAMPCTRL.reg = ADC_SAMPCTRL_SAMPLEN(1);  //Set Sampling Time Length to 1

analogReadResolution(10);
analogWriteResolution(10);

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {  

 if (digitalRead(SWITCH1)){
 float incr = (2.0 + analogRead(SLIDER1))/10000.0; //mod frequency
 if (increment < 0){increment = -incr;} else{ increment = incr;}
 }

 if (digitalRead(SWITCH2)){
 depthLO = analogRead(SLIDER2)/2030.0;
 depthHI = 1.0 - depthLO;
 }
 
//make triangle wave for modulation. Ramp up, Ramp down
  mod += increment;
  if(mod > depthHI || mod < depthLO){
    increment = -increment;
    mod += increment;
  }

 //Serial.println(mod, 4); //use Tools/Serial Plotter, turn on Serial in Setup
  
sampleIn = (analogRead(A1)) - midPoint; //Read ADC input
sampleOut = (float)sampleIn * mod;      // Modulation multiply 
analogWrite(A0, sampleOut + midPoint); // Write to DAC0 output

// toggle PA22 (LED2) each sample to check sample rate
// digitalWrite(LED2, !digitalRead(LED2));

} //End of Loop

//````````````````````````````````````````````````````````````
