
/* 
                  
                ADC1 to DAC0 with delay and pitch change
                
Send samples from a live ADC input to an array buffer.  
Output older samples from the array to DAC0.

Switch1 sets output pitch an octave lower. Switch2 set output pitch an octave higher.
Switch3 reads Slider3 with a delay value to lower sampling rate.
Switch4 reads Slider1 with a buffer size to help clean up the pitch change.

Thanks to "Arduino Music and Audio Projects" by Mike Cook
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define BUFFER_SIZE 10000  //10k x 2 bytes = 20k bytes, limited by the 32k SRAM size
short buffer1[BUFFER_SIZE]; // the size of a short is 2 bytes (16 bits)

// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right

//
//DIGIITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

// Initialize the buffer contents to all zero
  for (int i=0; i<BUFFER_SIZE; i++){
    buffer1[i] = 0;
  }

   Serial.begin(9600);  //used only for printing samplerate times

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);

ADC->CTRLB.reg = ADC_CTRLB_PRESCALER_DIV32 |  //Divde 48Khz GCLK by 32 for ADC
                 ADC_CTRLB_RESSEL_12BIT;       //Set ADC resolution to 12 bits
while(ADC->STATUS.bit.SYNCBUSY);              // Wait for these changes to sync

//Sampling Time Length SAMPLEN (normally 63) allows time for ADC capacitor to charge
ADC->SAMPCTRL.reg = ADC_SAMPCTRL_SAMPLEN(1);  //Set Sampling Time Length to 1

analogReadResolution(12);  //sample manipulations are done at higher resolution
analogWriteResolution(10); //highest resolution of MKRZero DAC

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {  

static signed int bufferIn = BUFFER_SIZE - 1; //input pointer set to array top
static unsigned int bufferOffset = BUFFER_SIZE - 1;   //output offset from input, sets maximum delay 
static signed int bufferOut = BUFFER_SIZE - bufferOffset; //output pointer
static unsigned int buffersize = BUFFER_SIZE - 1;
static signed int sample; 
static signed int delayMicros = 1; 
int timeIn;


 
while(1){  // inner loop for higher sample rate

 timeIn = micros();

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Two ways to change the delay time ~~~~~~~~~~~~~~~~~~~~~~~~~~
  
//lowers the sampling rate to increase delay, results in foldover frequencies with larger delays

  if (digitalRead(SWITCH3)){ delayMicros = analogRead(SLIDER3) >> 3; }
  delayMicroseconds(delayMicros);

//set up different buffer sizes less than max of BUFFER_SIZE

 if (digitalRead(SWITCH4)){ 
  buffersize =  analogRead(SLIDER1) << 1; 
  bufferOffset = buffersize - 1;
  }
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   
  
  sample = analogRead(A1) - 2048;  //make audio bipolar, plus and minus with 12 bit resolution
  //any multiply or divide operations must be done on bipolar signals with zero offsets

  //do any operations on the samples here
  
  buffer1[bufferIn] = sample;  //save sample in delay array

  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Frequency Shift an Octave Lower ~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  if(digitalRead(SWITCH1)){  //save sample in delay array a second time for octave lower output
            bufferIn++;
            if (bufferIn >= buffersize){ bufferIn = 0; }
            buffer1[bufferIn] = sample;  
  }  //End of SWITCH
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  
  
  sample = buffer1[bufferOut] + 2048;    //get output sample, make unipolar 
  analogWrite(A0, sample >> 2);   //send sample to DAC0, 12 to 10 bit resolution change

// update the two circular array pointers, input and output

 bufferIn++;
  if (bufferIn >= buffersize){
    bufferOut = bufferIn - bufferOffset ;  //line needed when randomly changing bufferOffset
    bufferIn = 0;
  }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~Frequency Shift an Octave Higher ~~~~~~~~~~~~~~~~~~~~~~~~~~
   
  if (digitalRead(SWITCH2)){ bufferOut += 2; } //bufferOut reads every other sample for octave higher 
  else { bufferOut ++ ; }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

if (bufferOut >= (buffersize)) {    
      bufferOut = bufferIn - bufferOffset ;
      if (bufferOut <= 0){ bufferOut += buffersize;}
  }

 
timeIn = micros() - timeIn;
Serial.println(timeIn);  //print sample rate time in microseconds
 
} //end of while 
} //End of loop


//````````````````````````````````````````````````````````````
