
/* 
                  Print Sensor Values.  Test 3 Arduino Voices  LEDs tied to Switches 1 & 2
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 
// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right


int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch


boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;


#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED


unsigned int freq = 50;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

  delay(1000);

Serial.begin(9600);

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);

//noTone(VOICEPIN_A);

}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

  digitalWrite(VOICEPIN_A, LOW);
  delay(slider1);

 int x = switchCombo();
  
  loadSensors();
  
   Serial.print("s1 = ");
  Serial.print(slider1);
    Serial.print("  s2 = ");
  Serial.print(slider2);
    Serial.print("   s3 = ");
  Serial.print(slider3);
    Serial.print("   s4 = ");
  Serial.print(slider4);
    Serial.print("   s5 = ");
  Serial.print((50 + (slider3 >> 1)));

 Serial.print("     ");

   Serial.print("  switches ");
  Serial.print(switch1);
  Serial.print(switch2);
  Serial.print(switch3);
  Serial.println(switch4);

  
  //tone(VOICEPIN_A, freq);
  digitalWrite(VOICEPIN_A, HIGH);
  delay(slider1);

/*  
freq = 0 + (slider1 >> 1);  
//tone(VoicePinA, freq);

//int v = map(slider2, 0, 1024, 1, 255);

 digitalWrite(VoicePinA, HIGH);
 //  digitalWrite(VoicePinB, HIGH);
  
  delay(freq );
  digitalWrite(VoicePinA, LOW);
 // digitalWrite(VoicePinB, LOW);
  delay(10);
*/

 
} //End of Loop

//````````````````````````````````````````````````````````````

void loadSensors(){      // load all current sensor values
      slider1 =   analogRead(SLIDER1) ;
      slider2 =   analogRead(SLIDER2) ;
      slider3 =   analogRead(SLIDER3) ;
      slider4 =   analogRead(SLIDER4) ;
      
      switch1 = digitalRead(SWITCH1);
      switch2 = digitalRead(SWITCH2);
      switch3 = digitalRead(SWITCH3);
      switch4 = digitalRead(SWITCH4);     
}

int switchCombo(){
    int result = switch2 + (switch1 * 2);

    switch (result) {
      case 0:
              digitalWrite(LED2, LOW);
              digitalWrite(LED1, LOW);
              break;
      case 1:
              digitalWrite(LED2, HIGH);
              digitalWrite(LED1, LOW);
              break;
      case 2:
              digitalWrite(LED2, LOW);
              digitalWrite(LED1, HIGH);
              break;
      case 3:
              digitalWrite(LED2, HIGH);
              digitalWrite(LED1, HIGH);
              break;
    }
    return result;   
}
