
/* 
                  
                Test 3 Arduino Voices 
                
VoiceA on volume knob A uses the tone() function with Slider 1 controlling freq
VoiceB on volume knob B uses the delay() function with Slider 2 controlling freq
VoiceC on distortion knob uses the same delay() function as Voice B

Voice C is an octave higher in frequency than Voice B
Voice C is used to distort Voices A and B as controlled by the Distortion knob
    with the switch in the up position.

*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// 
// ANALOG INPUTS
//
#define SLIDER1 A5  //top left
#define SLIDER2 A3  //bottom left
#define SLIDER3 A4  //top right
#define SLIDER4 A2  //bottom right


int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
#define SWITCH1 5  //top toggle switch
#define SWITCH2 4  //bottom toggle switch
#define SWITCH3 6  //right pushbutton switch
#define SWITCH4 7  //left pushbuttun switch


boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;


#define VOICEPIN_A 8   //pot 4 on box right side
#define VOICEPIN_B 9   //pot 5 on box right side
#define VOICEPIN_C 10  //Modulating Voice (white knob on box left side, and switch up)

#define LED1 1  //top toggle switch's LED
#define LED2 0  //bottom toggle switch's LED


unsigned int freq = 50;
unsigned int lastfreq = 50;
bool bb = 1;
bool cc = 1;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {

  delay(1000);

pinMode(LED1, OUTPUT);
digitalWrite(LED1, HIGH);
pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VOICEPIN_A, OUTPUT);
digitalWrite(VOICEPIN_A, LOW);
pinMode(VOICEPIN_B, OUTPUT);
digitalWrite(VOICEPIN_B, LOW);
pinMode(VOICEPIN_C, OUTPUT);
digitalWrite(VOICEPIN_C, LOW);

pinMode(SWITCH1, INPUT); //Switch inputs have external 10k pulldown resistor
pinMode(SWITCH2, INPUT);
pinMode(SWITCH3, INPUT);
pinMode(SWITCH4, INPUT);


}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                     Main LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

 bb = !bb;  // toggle the boolean bb value
 if (bb){ cc = !cc; }  // toggle the boolean cc value at 1/2 the freq of bb
 
 digitalWrite(VOICEPIN_C, bb);
 digitalWrite(VOICEPIN_B, cc);

 //slider2 affects freq of Voices B&C
 delayMicroseconds(analogRead(SLIDER2) << 1 ); 

//  tone() is used to set up VoiceA at freq set by slider1.
//  there is a click whenever the freq value in tone() is changed
//  so new freq values are only loaded when slider1 changes more than 10


  freq = analogRead(SLIDER1) ;
  if ( abs(freq - lastfreq) > 10) {
        tone(VOICEPIN_A, 40 + freq);
        lastfreq = freq; 
  }

 
} //End of Loop

//````````````````````````````````````````````````````````````
