
/* 
       3-VOICE ARDUINO SYNTHESIZER
      
      3 squarewave tones produced from Arduino pins 
      
      Slider3 - Sets Frequency of Tone3 with arduino tone(), used as the modulating voice
      Slider1 - Sets Frequency of Tone1
      Slider2 - Sets Frequency of Tone2

      Switch1 - turns off or on Tone1 slider adjustments
      Switch2 - turns off or on Tone2 slider adjustments
      Switch3 - Loads slider value for modulating voice

Arduino's tone() function can only be used to set up a squarewave on one output.
Arduino's tone() function also will stop working if loaded faster than every 50ms
Arduino's tone() function pops when loaded with the same freq value.

Two voices are created from a fast loop clock decrementing two freq values and toggling voice outputs
when they reach zero.  The freq values determine the pitch of the voices. Voice pitches are
also affected by any changes in the main program loop speed (other voices changing frequencies or 
going in or out of IF statements).  Higher frequencies affected more than lower.  Changes in the loop
time cause phasing between the two voices.

      
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// 
// ANALOG INPUTS
//
const int Slider1 = A5;
const int Slider2 = A3;
const int Slider3 = A4;
const int Slider4 = A2;


int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 5;
const int Switch2 = 4;
const int Switch3 = 6;
const int Switch4 = 7;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

const int VoicePinA = 8;
const int VoicePinB = 9;
const int VoicePinC = 10;

const int LED1 = 1;
const int LED2 = 0;

unsigned int freq1 = 50;
unsigned int freq2 = 50;
unsigned int freq3 = 50;

unsigned int freq1save = 50;
unsigned int freq2save = 50;
unsigned int dummy = 50;

boolean lastSwitch = 0;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);
  
pinMode(LED1, OUTPUT);    //turn on LED1 as power indicator
digitalWrite(LED1, HIGH);

pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VoicePinA, OUTPUT);
digitalWrite(VoicePinA, LOW);
pinMode(VoicePinB, OUTPUT);
digitalWrite(VoicePinB, LOW);
pinMode(VoicePinC, OUTPUT);
digitalWrite(VoicePinC, LOW);

pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistor
pinMode(Switch2, INPUT);
pinMode(Switch3, INPUT);
pinMode(Switch4, INPUT);
                     

} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {  //keep loop time as low as possible for better voice ranges, limit analogReads

     switch4 = digitalRead(Switch4);  //used to load slider3 setting for modulating voice frequency
    
    if ((switch4 == 0) && (lastSwitch == 1)){        // loads only on high to low switch transition (edge)                             
        tone(VoicePinC, 50 + (analogRead(Slider3) << 2));  
        lastSwitch = 0;
    }
    else if ((switch4 == 1) && (lastSwitch == 0)){
        lastSwitch = 1;
    }



    --freq1;                          //toggle voicePinA at end of freq1 countdown
    if (freq1 <= 0){
        digitalWrite(VoicePinA, !digitalRead(VoicePinA));        
        freq1 = freq1save;
        
        if (digitalRead(Switch2)){    // turn off or on VoicePinA frequency adjustments, hold a pitch
          freq1save = 2 + (analogRead(Slider2) << 1);
        }
       
    }

     --freq2;                         //toggle voicePinB at end of freq2 countdown
    if (freq2 <= 0){
        digitalWrite(VoicePinB, !digitalRead(VoicePinB));
        freq2 = freq2save;
        
        if (digitalRead(Switch1)){   // turn off or on VoicePinB frequency adjustments
          freq2save = 2 + (analogRead(Slider1) << 1);
        }
        
    }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                    END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
