
/* 
       3-VOICE ARDUINO SYNTHESIZER

      Uses the library Timer5Lib to set up a timer interrupt routine
      
      3 squarewave tones produced from Arduino pins 
      
      Slider3 - Sets Frequency of Tone3 used as the modulating voice
      Slider1 - Sets Frequency of Tone1
      Slider2 - Sets Frequency of Tone2

      Switch1 - turns off or on Tone1 slider adjustments
      Switch2 - turns off or on Tone2 slider adjustments
  

Three voices are created from a timer interrupt, decrementing 3 freq values and toggling voice outputs
when they reach zero.  Freq values determine the pitch of the voices. Voice pitches are
also affected by any changes in the main program loop speed (other voices changing frequencies or 
loading slider and swtich values).  Higher frequencies affected more than lower. Changes in the loop
time causes phasing between the two voices.

      
*/
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      CONSTANTS and Variables
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// 
// ANALOG INPUTS
//
const int Slider1 = A5;
const int Slider2 = A3;
const int Slider3 = A4;
const int Slider4 = A2;


int slider1 = 0;
int slider2 = 0;
int slider3 = 0;
int slider4 = 0;

//
//DIGIITAL SWITCHES
//
const int Switch1 = 5;
const int Switch2 = 4;
const int Switch3 = 6;
const int Switch4 = 7;

boolean switch1 = 0;
boolean switch2 = 0;
boolean switch3 = 0;
boolean switch4 = 0;

const int VoicePinA = 8;
const int VoicePinB = 9;
const int VoicePinC = 10;

const int LED1 = 1;
const int LED2 = 0;

volatile int freq1 = 50;
volatile int freq2 = 50;
volatile int freq3 = 50;

volatile int freq1save = 50;
volatile int freq2save = 50;
volatile int freq3save = 50;
unsigned int load = 50;

boolean lastSwitch = 0;

#include "Timer5.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      SETUP()
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


void setup() {

delay(1000);
  
pinMode(LED1, OUTPUT);    //turn on LED1 as power indicator
digitalWrite(LED1, HIGH);

pinMode(LED2, OUTPUT);
digitalWrite(LED2, LOW);


pinMode(VoicePinA, OUTPUT);
digitalWrite(VoicePinA, LOW);
pinMode(VoicePinB, OUTPUT);
digitalWrite(VoicePinB, LOW);
pinMode(VoicePinC, OUTPUT);
digitalWrite(VoicePinC, LOW);

pinMode(Switch1, INPUT);  // Set up switch inputs with pullup resistor
pinMode(Switch2, INPUT);
pinMode(Switch3, INPUT);
pinMode(Switch4, INPUT);
                     
   // define frequency of interrupt
  MyTimer5.begin(15000);  // 200=for toggle every 5msec

    // define the interrupt callback function
    MyTimer5.attachInterrupt(timerInterrupt);
  
    // start the timer
    MyTimer5.start();
} //End of Setup

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                      MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {  //keep loop time as low as possible for better voice ranges, limit analogReads

    --load;     //Do all the reads every 1000 times through the loop.  Causes some pops and fuzzyness 
                //to the output tones, since it stretches one cycle time of the tones periodically
                //Switches used to stop and start analogReads - a hold frequency function.
                
    if (load <= 0){

      
      if (digitalRead(Switch1)){
        freq2save = 2 + (analogRead(Slider1) >> 2);
      }
      
      if (digitalRead(Switch2)){
        freq1save = 2 + (analogRead(Slider2) >> 2); 
      }
         
        freq3save = 2 + (analogRead(Slider3) >> 1); 
         
        load = 10000;
   }

   
   
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//                    END OF MAIN LOOP
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void timerInterrupt(void){
  
   --freq1;                          //toggle voicePinA at end of freq1 countdown
    if (freq1 <= 0){
        digitalWrite(VoicePinA, !digitalRead(VoicePinA));        
        freq1 = freq1save;
    }
       
     --freq2;                         //toggle voicePinB at end of freq2 countdown
    if (freq2 <= 0){
        digitalWrite(VoicePinB, !digitalRead(VoicePinB));
        freq2 = freq2save;
    }
    
     --freq3; 
      if (freq3 <= 0){
        digitalWrite(VoicePinC, !digitalRead(VoicePinC));
        freq3 = freq3save;  
    }
}
