/*
 Using the Sparkfun Pro Micro, 3.3v, 8MHz.  Set for TeeOnArdu/8MHz/USB type MIDI
                Y,X,Z Accelerometer 
                Analog Voltages sent as MIDI Controllers
 
 */
int channel = 0;      // MIDI Channel #, 0 through 15
int sensorCount = 3;   // number of sensors used

int controller[8] = { 24, 25, 26, 27, 0, 0, 0, 0}; //MIDI Controller numbers
int sensorValue[8] = { 0, 0, 0, 0, 0, 0, 0, 0};
int outputValue[8] = {-1, -1, -1, -1, -1, -1, -1, -1};  // map the sensor value to 0-127
int lastValue[8] = {-1, -1, -1, -1, -1, -1, -1, -1}; //used to avoid sending repeating values

//int maxVal[8] = {550, 550, 550, 550, 550, 0, 0, 0}; //max values for mapping A0-A7
//int minVal[8] = {310, 310, 310, 250, 250, 0, 0, 0};  //min values for mapping A0-A7

void setup() { 
 
  delay(2000);
  
}  // end of setup

void loop() {

for (int i=0; i<sensorCount; i++) {
   
       sensorValue[i] = analogRead(i); 
       outputValue[i] = map(sensorValue[i], 300, 700, 0, 127);
       outputValue[i] = constrain(outputValue[i], 0, 127); //no negative values

       if (outputValue[i] != lastValue[i]) {
         usbMIDI.sendControlChange(controller[i], outputValue[i], channel);
         lastValue[i] = outputValue[i];
       } // end of if

} // end of for loop

/*
Serial.print(outputValue[0]);
Serial.print("\t");
Serial.print(outputValue[1]);
Serial.print("\t");
Serial.print(outputValue[2]);
Serial.print("\t");
Serial.println();
*/
 delay(30);  
}  //end of loop



