/*
 Flex Sensor with Arduino Micro using TeeOnArdu with USB_MIDI output

 19k to 45K range, use 30K resistor.

 sendControlChange(Byte inControlNumber, Byte inControlValue, inChannel);
 */

byte channel = 0;      // MIDI Channel #, 1 to 16
byte controller = 22;  //16 is the first General Purpose Midi Controller Number
int sensorValue = 0;
int outputValue = -1;  // map the sensor value to 0-127
int lastValue = 0;     // used to avoid sending repeating values

void setup() {
  delay(2000); //Wait 2sec before sending. Makes uploading new sketches easier.
}  // end of setup

void loop() {

 sensorValue = analogRead(A0);  
 

 outputValue = map(sensorValue, 362, 600, 0, 127);
 outputValue = constrain(outputValue, 0, 127);
 
 if (outputValue != lastValue) {
   usbMIDI.sendControlChange(controller, outputValue, channel);
   lastValue = outputValue;
 }  // end of if

 delay(20);
  
}  //end of loop



