/*
 Two 10K pots on a JoyStick with Arduino Micro using TeeOnArdu with USB_MIDI output
 Make sure board selection is TeeOnArdu, Processor is 5volts/16MHz, USB type is MIDI

 sendControlChange(Byte inControlNumber, Byte inControlValue, inChannel);
 */

int channel = 0;      // MIDI Channel #, 1 to 16
int controller0 = 23; 
int controller1 = 24;  //16 is the first General Purpose Midi Controller Number
int sensorValue0 = 0;
int outputValue0 = -1;  // map the sensor value to 0-127
int lastValue0 = 0;     // used to avoid sending repeating values
int sensorValue1 = 0;
int outputValue1 = -1;  // map the sensor value to 0-127
int lastValue1 = 0;     // used to avoid sending repeating values

void setup() {
  delay(3000); //Wait 3sec before sending. Makes uploading new sketches easier.
}  // end of setup

void loop() {

 sensorValue0 = analogRead(A0);  
 outputValue0 = map(sensorValue0, 370, 664, 0, 127);
 outputValue0 = constrain(outputValue0, 0, 127); //no negative values in bright lights

 sensorValue1 = analogRead(A1);  
 outputValue1 = map(sensorValue1, 361, 657, 0, 127);
 outputValue1 = constrain(outputValue1, 0, 127);
 
 if (outputValue0 != lastValue0) {
   usbMIDI.sendControlChange(controller0, outputValue0, channel);
   lastValue0 = outputValue0;
 }  // end of if

  if (outputValue1 != lastValue1) {
   usbMIDI.sendControlChange(controller1, outputValue1, channel);
   lastValue1 = outputValue1;
 }  // end of if

 delay(20);
  
}  //end of loop



