/*
 Soft Pot Sensor with Arduino Micro using TeeOnArdu with USB_MIDI output

 The soft pot is about 9K.  Top of pot connected to 5v.  Bottom to GND through
 a 1k series resistor used to avoid short circuit damage that can happen when 
 top and bottom are both pressed.
 
 Center connected to GND through 47K resistor.  Results in 0 when not touched,
 32 at bottom, and 910 at top.  Values are remapped to 0-127.

 sendControlChange(Byte inControlNumber, Byte inControlValue, inChannel);
 */

byte channel = 0;      // MIDI Channel #, 1 to 16
byte controller = 16;  //16 is the first General Purpose Midi Controller Number
int sensorValue = 0;
int outputValue = -1;  // map the sensor value to 0-127
int lastValue = 0;     // used to avoid sending repeating values

void setup() {
  delay(2000); //Wait 2sec before sending. Makes uploading new sketches easier.
}  // end of setup

void loop() {

 sensorValue = analogRead(A0) - 32;  
 outputValue = constrain(sensorValue, 0, 878);
 outputValue = map(outputValue, 0, 878, 0, 127);
 
 if (outputValue != lastValue) {
   usbMIDI.sendControlChange(controller, outputValue, channel);
   lastValue = outputValue;
 }  // end of if

 delay(20);
  
}  //end of loop



