/*
 Sound Detector with Arduino Micro using TeeOnArdu with USB_MIDI output

Uses an Electret microphone connected to a opamp preamp with a gain of 100,  
followed by a Envelope Follower circuit (full wave rectifier charging a capacitor),
followed by a Schmitt Trigger Gate (high when an audio signal is present).

The Envelope Follower voltage is connected to A0, and the digital gate signal
is connected to pin 2.  Line level audio output is provided 
on a mini-phone jack.

 sendControlChange(Byte inControlNumber, Byte inControlValue, inChannel);
 usbMIDI.sendNoteOn(notes[i], 127, CHANNEL);   /* Send the MIDI note on message:
 */

byte channel = 0;      // MIDI Channel #, 1 to 16
byte controller = 26;  // 16 is the first General Purpose Midi Controller Number
byte note = 26;        // MIDI note number
int sensorValue = 0;
int outputValue = -1;  // map the sensor value to 0-127
int lastValue = 0;     // used to avoid sending repeating values
bool gateVal = 0;      // Read Gate value
bool lastGateVal = 0;  // Stored Gate Value

void setup() { 
delay(2000); //Wait 2sec before sending. Makes uploading new sketches easier.
} // end of setup

void loop() {

 sensorValue = analogRead(A0); 
 gateVal = digitalRead(2); 

 if (gateVal != lastGateVal){
    lastGateVal = gateVal;
    usbMIDI.sendNoteOn(note, (127 * gateVal), channel);    
 } // end of if
 
 outputValue = map(sensorValue, 10, 200, 0, 127);
 outputValue = constrain(outputValue, 0, 127);
 
 if (outputValue != lastValue) {
   usbMIDI.sendControlChange(controller, outputValue, channel);
   lastValue = outputValue;
 }  // end of if

 delay(20);
  
}  //end of loop



