/*
 Switches with Arduino Micro using TeeOnArdu with USB_MIDI output
 Make sure board selection is TeeOnArdu, Processor is 5volts/16MHz, USB type is MIDI

  A total of 8 switches -- 4 on a JoyStick (pins2,3,4,5),
  Two PushButton (pins 6,7), Two Toggle (pins 8,9).
  Two Phone Jacks are wired in parallel with the PushButtons for adding fabricated switch devices

  Switch debounce method:  When a switch change of state is first detected (currentVal != lastVal) don't
  do anything but make note of the change (changed=1).  On the next time around the loop, if the change
  of state is still there, send a Midi Note Message and reset values (currentVal = lastVal, changed = 0).
  If, on the other hand, on the next time around the loop, a change of state is not detected (the switch just 
  bounced back to its original state) then reset the changed bit to zero and start over again to allow the switch
  to settle.  Loop times are set by a "debounce" delay time.

 usbMIDI.sendNoteOn(notes[i], 127, CHANNEL);   /* Send the MIDI note on message:
  
 */
 
int CHANNEL = 0;      // MIDI Channel #, 1 to 16
int debounce = 25;    // debounce wait time
int switchPins[] = {2, 3, 4, 5, 6, 7, 8, 9}; // an array of pin numbers to which switches are attached
int pinCount = 8; // the number of switches (i.e. the length of the array)

bool currentVal[] = { 1,1,1,1,1,1,1,1}; //Just read switch values, normally high.
bool lastVal[] = { 1,1,1,1,1,1,1,1}; //Stored last switch value
bool changed[] = {0,0,0,0,0,0,0,0}; //test for changed switch value, 0 = not changed
int notes[] = {60, 61, 62, 63, 64, 65, 66, 67}; //MidiNoteOn notes starting at middle C 

void setup() {
 
  for (int thisPin = 0; thisPin < pinCount; thisPin++) {
    pinMode(switchPins[thisPin], INPUT_PULLUP); // Enable internal pullup resistors 
  } // end of for loop
  
  delay(3000); //Wait 3sec before sending. Makes uploading new sketches easier.
}  // end of setup

void loop() {
  
  for (int i = 0; i<pinCount; i++) {                // loop from the lowest switch pin to the highest:
 
    currentVal[i] = digitalRead(switchPins[i]);     // read switch value
    
              if((currentVal[i] != lastVal[i]) && (changed[i] = 1)){    // still changed after debounce wait                         
                            
                            if(currentVal[i] == 0){                       // send MidiNote On
                              usbMIDI.sendNoteOn(notes[i], 127, CHANNEL);                        
                            } 
                            else {                                                            
                              usbMIDI.sendNoteOff(notes[i], 127, CHANNEL); // Send MidiNote Off
                            } 
             
                  lastVal[i] = currentVal[i]; 
                  changed[i] = 0;
          
              } // end of if 

        else if  ((currentVal[i] != lastVal[i]) && (changed[i] = 0)){  // change detected. Do a debounce wait.
                changed[i] = 1;
         }     

        else if  ((currentVal[i] = lastVal[i]) && (changed[i] = 1)){   // after debounce-wait, false change.
                changed[i] = 0;
         }   

    
  } // end of for

  delay(debounce);

} // end of loop
