/*
 Tilt Switches with Arduino Micro using TeeOnArdu with USB_MIDI output
 Make sure board selection is TeeOnArdu, Processor is 5volts/16MHz, USB type is MIDI

  A total of 6 tilt switches -- paired as Up/Down, Left/Right, Forward/Backward.  Each switch has a 
  grounded case connection and a sensor output connected to an Arduino input with a pullup.

  Switch debounce method:  Each switch pair is set up as an active LOW Set/Reset Flip-Flop. 
  For example, any LOW on the Up Switch will set its UpDown variable to HIGH, and any LOW on the Down Switch 
  will reset UpDown to LOW.  Whenever the UpDown variable changes state, a MIDI Note On message is sent with
  either a HIGH velocity of 127  (UP) or a LOW velocity of 0 (DOWN).   HIGHs on a switch does nothing.

  The switches in a pair are physically mounted opposite of each other so that it is physically impossible
  for both to go low at the same time.

 usbMIDI.sendNoteOn(notes[i], Velocity, CHANNEL);   /* Send the MIDI note on message:
  
 */

//~~~~~~~~~~~~~~~~~~~~~Constants/Variables~~~~~~~~~~~~~~~~~~~~~~~~
 
int CHANNEL = 0;      // MIDI Channel Number

int UpDownNote = 72;  // MIDI NoteOn Note Number
int LeftRightNote = 73;
int ForwardBackNote = 74;

int const UP = 2;  // 6 Tilt switches are connected to these digital input pins
int const DOWN = 3;
int const LEFT = 4;
int const RIGHT = 5;
int const FORWARD = 6;
int const BACK = 7;

int UpDown = 0;  //Last saved state of each Tilt switch pair
int LeftRight = 0;
int ForwardBack = 0;

//~~~~~~~~~~~~~~~~~~~~~Setup~~~~~~~~~~~~~~~~~~~~~~~~

void setup() {
 
  delay(3000); //Wait 3sec before starting. Makes uploading new sketches easier.

  pinMode(UP, INPUT_PULLUP);   // Tilt switch pin connections
  pinMode(DOWN, INPUT_PULLUP);
  pinMode(LEFT, INPUT_PULLUP);
  pinMode(RIGHT, INPUT_PULLUP);
  pinMode(FORWARD, INPUT_PULLUP);
  pinMode(BACK, INPUT_PULLUP);
  
}  // end of setup

//~~~~~~~~~~~~~~~~~~~~~Main Loop~~~~~~~~~~~~~~~~~~~~~~~~

void loop() {

//~~~~~~~~~~~~~~~~~~~~~Up/Down~~~~~~~~~~~~~~~~~~~~~~~~

  if (!(digitalRead(UP)) && (UpDown == 0)){
        UpDown = 1;
        usbMIDI.sendNoteOn(UpDownNote, 127, CHANNEL); 
  }
  if (!(digitalRead(DOWN)) && (UpDown == 1)){
        UpDown = 0;
        usbMIDI.sendNoteOn(UpDownNote, 0, CHANNEL); 
  }


//~~~~~~~~~~~~~~~~~~~~~Left/Right~~~~~~~~~~~~~~~~~~~~~~~~

  if (!(digitalRead(LEFT)) && (LeftRight == 0)){
        LeftRight = 1;
        usbMIDI.sendNoteOn(LeftRightNote, 127, CHANNEL); 
  }
  if (!(digitalRead(RIGHT))  && (LeftRight == 1)){
        LeftRight = 0;
        usbMIDI.sendNoteOn(LeftRightNote, 0, CHANNEL); 
  }


//~~~~~~~~~~~~~~~~~~~~~Forward/Back~~~~~~~~~~~~~~~~~~~~~~~~

  if (!(digitalRead(FORWARD)) && (ForwardBack == 0)){
        ForwardBack = 1;
        usbMIDI.sendNoteOn(ForwardBackNote, 127, CHANNEL); 
  } 
  if (!(digitalRead(BACK))  && (ForwardBack == 1)){
        ForwardBack = 0;
        usbMIDI.sendNoteOn(ForwardBackNote, 0, CHANNEL); 
  }


} // end of loop
