#ifndef CODEC_H_
#define CODEC_H_

//#pragma once
#include <Arduino.h>
#include "set_settings.h"
#include <Wire.h>
#include <stdint.h>

typedef enum
{
  XBM_LR,	//bypass both L and R channel (default)
	XBM_L,	//bypass L channel only
	XBM_R  	//bypass R channel only
} bypass_mode_t;

typedef enum {
  MIXIN1,  // direct line 1
  MIXIN2,  // direct line 2
  MIXRES,  // reserverd codec
  MIXADC   // Select from ADC/ALC
} mixsel_t;

typedef enum {
  OUT1,    // Select Line OUT L/R 1
  OUT2,    // Select Line OUT L/R 2
  OUTALL,  // Enable ALL
} outsel_t;

typedef enum {
  IN1,      // Select Line IN L/R 1
  IN2,      // Select Line IN L/R 2
  IN1DIFF,  // differential IN L/R 1
  IN2DIFF   // differential IN L/R 2
} insel_t;

typedef enum {
  DACOUT,     // Select Sink From DAC
  SRCSELOUT,  // Select Sink From SourceSelect()
  MIXALL,     // Sink ALL DAC & SourceSelect()
} mixercontrol_t;

typedef enum {
  DISABLE,  // Disable ALC
  GENERIC,  // Generic Mode
  VOICE,    // Voice Mode
  MUSIC     // Music Mode
} alcmodesel_t;

class Codec {
 private:
  int inmode;
  outsel_t _outSel = OUTALL;
  insel_t _inSel = IN1;
  TwoWire i2c = TwoWire(0);
  uint8_t _pinsda, _pinscl;
  uint32_t _i2cspeed;
  bool write_reg(uint8_t reg_add, uint8_t data);
  uint8_t read_reg(uint8_t reg_add);

 public:
 float outCorrectionGain;
	bool* muteLeftAdcIn;
	bool* muteRightAdcIn;

//get and set the input mode
//mode 0: L+R, mode 1: L+MIC
	bool setInputMode(int mode){inmode = mode; return true;};
	int getInputMode(){ return inmode;};
	
//get and set microphone gain (0:0dB,1-7:30dB-48dB)
	virtual uint8_t getMicGain();
	virtual bool setMicGain(uint8_t gain);
	
//get and set microphone noise gate (0-31: -76.5dB, -75.0dB,...., -30.0dB)
	virtual int getMicNoiseGate();
	virtual bool setMicNoiseGate(int gate);

//optimize the analog to digital conversion range
//range: 0, 1, 2, 3, 4 (1Vrms/2.83Vpp, 0.5Vrms/1.41Vpp, 0.25Vrms/707mVpp, 0.125Vrms/354mVpp, 0.625Vrms/177mVpp)
	virtual void optimizeConversion(int range=2);
	
//bypassed the analog input to the output, disconnect the digital i/o 
//virtual bool analogBypass(bool bypass, bypass_mode_t bm=XBM_LR);  

//bypassed the analog input to the output, disconnect the digital input, preserve the digital output connection
	virtual bool analogSoftBypass(bool bypass, bypass_mode_t bm=XBM_LR); 

  Codec(uint8_t _sda, uint8_t _scl, uint32_t _speed);

  ~Codec();

  bool init();

  bool identify(int sda, int scl, uint32_t frequency);

  uint8_t* readAllReg();

  bool outputSelect(outsel_t sel);
  bool inputSelect(insel_t sel);

  bool DACmute(bool mute);

  uint8_t getOutputVolume();
  bool setOutputVolume(uint8_t vol);

  uint8_t getInputGain();
  bool setInputGain(uint8_t gain);

  bool setALCmode(alcmodesel_t alc);

  bool mixerSourceSelect(mixsel_t LMIXSEL, mixsel_t RMIXSEL);
  bool mixerSourceControl(bool LD2LO, bool LI2LO, uint8_t LI2LOVOL, bool RD2RO,
                          bool RI2RO, uint8_t RI2LOVOL);
  bool mixerSourceControl(mixercontrol_t mix);

  bool analogBypass(bool bypass);

  bool setBitsPerSample();
};

#endif