#include <Arduino.h>
#include "set_settings.h"
#include "set_module.h"
#include "set_codec.h"
#include "task.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~SETUP~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() 
{
  Serial.begin(115200);
  delay(3000);

 //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 //Codec Codec is initialized using i2c.  See Codec.cpp

  Serial.println("Initialize Codec Codec ");
  if (!codec.init()) Serial.println("Init Fail");
  else {
    escodec_sets();
    Serial.println("8388 Init success!!"); }
  delay(500);

  // Sets i2s Master Clock on GPIO pin 0 when I2S_NUM is 0
  PIN_FUNC_SELECT(PERIPHS_IO_MUX_GPIO0_U, FUNC_GPIO0_CLK_OUT1);
  WRITE_PERI_REG(PIN_CTRL, 0xFFF0);

  i2s_driver_install((i2s_port_t)I2S_NUM, &i2s_config, 0, NULL);
  i2s_set_pin((i2s_port_t)I2S_NUM, &pin_config);
  i2s_set_clk((i2s_port_t)I2S_NUM, SAMPLE_RATE, BITS_PER_SAMPLE, (i2s_channel_t) CHANNEL_COUNT);
   
  //~~~~~~~~~~~~~~~~~Monitor~~~~~~~~~~~~~~~~~~~~~~~~~~~~

        uint8_t *reg;  //Print values of all Codec registers
        for (uint8_t i = 0; i < 53; i++) 
      {   
        reg = codec.readAllReg();  
        Serial.printf("Reg-%02d = 0x%02x\r\n", i, reg[i]);
      }
        Serial.println("I2S setup complete");
        runSystemMonitor();  //for testing only

} //Setup End


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~MAIN LOOP~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() 
{
  //leave the main loop dedicated only to the I2S audio task

  size_t readsize = 0;
  int16_t rxbuf[FRAMELENGTH], txbuf[FRAMELENGTH]; //128 L+R signed 16 bit samples 
  //int32_t rxbuf[FRAMELENGTH], txbuf[FRAMELENGTH]; //128 L+R signed 32 bit samples 
  float rxl, rxr, txl, txr;  //left and right single samples, processed as floats

  myPedal->init();
  taskSetup();

  while(1){   //signal processing loop

  /*
   read 256 samples = FRAMELENGTH (128 Left+Right signed samples). It's also the size of buffers.
   read 2 bytes for each 16 bit (2 byte) sample (FRAMLENGTH*2)
   rxbuf[] and txbuf[] defined with signed 16 bit integers (int16_t) and of FRAMELENGTH size. 
 */
  //gather some input samples into receive buffer from the DMA memory,
  i2s_read(I2S_NUM_0, rxbuf, FRAMELENGTH*2, &readsize, 20);
  
  for (int i=0; i<(FRAMELENGTH); i+=2) {  //process samples one at a time from buffers
    
    rxl = (float) (rxbuf[i]) ;   //convert sample to float
    rxr = (float) (rxbuf[i+1]) ; 

    rxl = myPedal->gain * myPedal->gainRange * rxl;  //left-right signal processing on sample
    rxr = myPedal->gain * myPedal->gainRange * rxr;

    txbuf[i]   = ((int16_t) rxl) ; //convert sample back to integer
    txbuf[i+1] = ((int16_t) rxr) ;
  }
  // play processed receive buffer by loading transmit buffer into DMA memory
  i2s_write(I2S_NUM_0, txbuf, FRAMELENGTH*2, &readsize, 20);

} // End of while(1) loop
} // End of Main Loop

