#include "set_codec.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// define codec codec and run i2c.begin()
   Codec codec(Codec_SDA, Codec_SCK, 400000);
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  
 //Some functions built to load Codec registers, all are set in Codec.init()
 void escodec_sets()  //to be executed in main.cpp
 {
  codec.setBitsPerSample(); //set up 16 or 24 based on BITS_PER_SAMPLE
  codec.inputSelect(IN2); //IN1, IN2, IN1DIFF, IN2DIFF
  codec.setInputGain(8);  //max of 8 +24db
  codec.outputSelect(OUT1);  //OUT1, OUT2, OUTALL
  codec.setOutputVolume(20); //max of 33
  // MIXIN1–direct IN1, MIXIN2-IN2, MIXRES–reserved, MIXADC–ADC/ALC input (after mic amp)
  codec.mixerSourceSelect(MIXIN2, MIXIN2); 
  // DACOUT -> DAC, SRCSEL -> SourceSelect(), MIXALL -> DACOUT + SRCSEL
  codec.mixerSourceControl(DACOUT);
  codec.setALCmode(MUSIC); //DISABLE, GENERIC, VOICE, MUSIC
  codec.DACmute(0);  //1 -> mute, 0 -> don't mute
  //default optimization for Codec-version module  is 1/4 Vrms range -> 2
  //to optimize for the 1 Vrms range (more noisy) -> 0
  codec.optimizeConversion(2);
  };
