
#include "set_settings.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// I2S Configuration / from i2s driver library 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

i2s_config_t i2s_config = {
    .mode = (i2s_mode_t)(I2S_MODE_MASTER | I2S_MODE_TX | I2S_MODE_RX),
    .sample_rate = SAMPLE_RATE,
    .bits_per_sample = (i2s_bits_per_sample_t) BITS_PER_SAMPLE,
    .channel_format = I2S_CHANNEL_FMT_RIGHT_LEFT,
    .communication_format = I2S_COMM_FORMAT_STAND_I2S,
    .intr_alloc_flags = 0,
    .dma_buf_count = DMABUFFERCOUNT, 
    .dma_buf_len = DMABUFFERLENGTH,   
    .use_apll = false,
    .tx_desc_auto_clear = true,
    .fixed_mclk = 0 
  };

 i2s_pin_config_t pin_config = {
    .bck_io_num = I2S_BCK_IO_ES, 
    .ws_io_num = I2S_WS_IO_ES, 
    .data_out_num = I2S_DO_IO_ES, 
    .data_in_num = I2S_DI_IO_ES
  };