#ifndef SETTINGS_H_
#define SETTINGS_H_
  
  #pragma once
  #include "codec.h"
  #include <Arduino.h>
  //#include "effectmodule.h"
  #include "driver/i2s.h"

  #define SAMPLE_RATE     (44100)
  #define BITS_PER_SAMPLE (16)
  #define CHANNEL_COUNT 2

 // The following pin connections were used in JT Codec Box Project
 // 6 possible pot connections, 4 switches, any number LEDs
  #define POT1 34
  #define POT2 39
  #define POT3 36
  #define POT4 14
  #define POT5 12  //must be set near zero for program load to work
  #define LIGHT 27

  #define LED1  4
  #define LED2  19
  #define KEY1  32
  #define KEY2  33

//pins available for OLED Display or other I2C device
#define SCK_PIN 22
#define SDA_PIN 21

//ESP32-Codec Codec PIN SETUP
#define I2S_NUM			(0)
#define IS2_MCLK_PIN		(0)
#define I2S_BCK_IO_ES	   (5)
#define I2S_WS_IO_ES    (25)
#define I2S_DI_IO_ES    (35)
#define I2S_DO_IO_ES    (26)

#define Codec_SDA		18
#define Codec_SCK		23
#define Codec_ADDR		0x10 

//audio processing frame length in samples (L+R) 64 samples (32R+32L) 256 Bytes
//Used as size of i2s input and output buffers
#define FRAMELENGTH    256
//audio processing priority
#define AUDIO_PROCESS_PRIORITY  10

//SRAM used for DMA = DMABUFFERLENGTH * DMABUFFERCOUNT * BITS_PER_SAMPLE/8 * CHANNEL_COUNT
//Lower number for low latency, Higher number for more signal processing time
//Must be value between 8 and 1024 in bytes
#define DMABUFFERLENGTH 64

//number of above DMA Buffers of DMABUFFERLENGTH
#define DMABUFFERCOUNT  2

  // processor timing variables for system monitor, also included in task.cpp
  extern unsigned int runningTicks;
  extern unsigned int usedticks;
  extern unsigned int availableticks;
  extern unsigned int availableticks_start;
  extern unsigned int availableticks_end;
  extern unsigned int usedticks_start;
  extern unsigned int usedticks_end;
  extern unsigned int processedframe;
  extern unsigned int audiofps;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~ I2S receive and transmit buffers ~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

//Audio samples are pulled from the ADC DMA buffers and loaded into rxbuf for processing
//Processed Audio samples are loaded into txbuf to be transferred to the DAC DMA buffer

  extern int16_t rxbuf[FRAMELENGTH], txbuf[FRAMELENGTH]; //128 L+R signed 16 bit samples 
//extern int32_t rxbuf[FRAMELENGTH], txbuf[FRAMELENGTH]; //128 L+R signed 32 bit samples 
  extern float rxl, rxr, txl, txr;  //left and right single samples, processed as floats
 
  extern i2s_config_t i2s_config;
  extern i2s_pin_config_t pin_config;

#endif