
#include "set_module.h"
#include "set_settings.h"
#include "set_codec.h"

//controller_module myPedal definition
controller_module *myPedal = new controller_module();

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~ CONTROLLER MODULE CLASS DEFINITIONS ~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Define the ControllerModule functions declared above
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::init()  //effect module class initialization
 {
  name = "PUCA";
  inputMode = IM_LR;   // IM_LR or IM_LMIC

  // Set up pin Modes for the switches and LEDs
  // Some need pullup resistor.
  // Most have hardware pullup resistors. 
  pinMode(KEY1, INPUT_PULLUP); 
  pinMode(KEY2, INPUT_PULLUP);
  pinMode(KEY3, INPUT_PULLUP);
  pinMode(KEY4, INPUT_PULLUP);

  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);

  //setting up the buttons
  
  button[0].name = "KEY1";
  button[0].mode = BM_MOMENTARY;
  button[0].pin = KEY1;

  button[1].name = "KEY2";
  button[1].mode = BM_TOGGLE;
  button[1].pin = KEY2;
  
  button[2].name = "KEY3";
  button[2].mode = BM_TOGGLE;
  button[2].pin = KEY3;
  
  button[3].name = "KEY4";
  button[3].mode = BM_MOMENTARY;
  button[3].pin = KEY4;

  //add gain control
  control[0].name = "Gain";
  control[0].mode = CM_POT;
  control[0].levelCount = 128;
  control[0].pin = POT1;

  //add range control
  control[1].name = "Range";
  control[1].mode = CM_SELECTOR;
  control[1].levelCount = 3;
  control[1].pin = POT2;

  gain = 1.0;
  gainRange = 1.0;
 }

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onButtonChange(int buttonIndex)
{
  switch(buttonIndex)
  {
    case 0: //"KEY1" button state has changed
    {
      if(button[0].value) //if effect is activated
      {
        //codec.loopback(0);
        codec.hpVolSet(40, 40);
        digitalWrite(LED1, HIGH);
      }
      else //if effect is bypassed
      {
        //codec.loopback(1); 
        codec.hpVolSet(0, 0);
        digitalWrite(LED1, LOW);
      }
      break;
    }
    
    case 1: // "KEY2" button[1] state has changed
    {
      if(button[1].value) // just test LED and Switch
      {digitalWrite(LED2, HIGH);}
      else \
      {digitalWrite(LED2, LOW);}
      break;
    }
  }
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onControlChange(int controlIndex)
{
  switch(controlIndex)
  {
    case 0:
    {
      gain = (float)control[0].value/127.0;
      break;
    }
    case 1:
    {
      if(control[1].value==0)
        gainRange = 1;
      else if(control[1].value==1)
        gainRange = 2;
      else gainRange = 3;
      break;
    }
  }
}
