#ifndef SETTINGS_H_
#define SETTINGS_H_
  
  #pragma once
  #include "codec.h"
  #include <Arduino.h>
  #include "driver/i2s.h"

  #define SAMPLE_RATE     (32000)
  #define BITS_PER_SAMPLE (16)
  #define CHANNEL_COUNT 2

  //Sparkfun Codec/ESP32 Thing Plus C PIN ASSIGNMENTS
  //~~~~~~~~~~~~~~~~~~~~~~~~~~~

  #define POT1 14          
  #define POT2 32         
  #define POT3 39
  #define POT4 36
  #define POT5 33
  #define POT6 34
  
  #define LED1 13  //onboard Blue LED, ESP32 Sparkfun Thing Plus
  #define LED2 12
  
  #define KEY1 15  
  #define KEY2 27  
  
  #define TOUCH_THRESHOLD 30  //for touch switches

//ESP32-Codec PIN SETUP
#define I2S_NUM			(0)
//#define IS2_MCLK_PIN (0) //onboard Osc Chip, MCLK of 24MHz, on Sparkfun Codec
#define I2S_BCLK	  (4)   //BCLK, SCK, SCLK
#define I2S_LRC     (25)  //LRC, WS, ADCLRC, DACLRC, LRCLK  -- Left/Right channel indicator
#define I2S_DIN     (35)  //DIN, ADCDAT, SD --  data into ESP32 from ADC output
#define I2S_DOUT    (26)  //DOUT, DACDAT, SDO -- data out of ESP32 to DAC input

// I2C address (7-bit format for Wire library)
//#define WM8960_ADDR 0x1A  //left on codec.h
// I2C on Qwiic Connector 
#define Codec_SDA	     21  
#define Codec_SCK		   22 
#define I2C_MASTER_SCL_IO 22
#define I2C_MASTER_SDA_IO 21
#define I2C_SDA        21
#define I2C_SCL        22

#define I2C_MASTER_NUM 1    //I2C port number for master dev 
#define I2C_MASTER_FREQ_HZ 100000
#define I2C_MASTER_TX_BUF_DISABLE 0
#define I2C_MASTER_RX_BUF_DISABLE 0

//SD Card Reader Settings

#define SD_CARD_CS   5
#define SD_CARD_MISO 19
#define SD_CARD_MOSI 23
#define SD_CARD_CLK  18

#define SAMPLES_BUFFER_SIZE 1024

//NEO PIXEL SETTINGS
#define PIN 2  //Built in RGB on ESP32 Thing Plus
#define NUM_LEDS 1
#define BRIGHTNESS 5

//audio processing frame length in samples (L+R) 64 samples (32R+32L) 256 Bytes
//Used as size of i2s input and output buffers
#define FRAMELENGTH    256
//audio processing priority
#define AUDIO_PROCESS_PRIORITY  10

//SRAM used for DMA = DMABUFFERLENGTH * DMABUFFERCOUNT * BITS_PER_SAMPLE/8 * CHANNEL_COUNT
//Lower number for low latency, Higher number for more signal processing time
//Must be value between 8 and 1024 in bytes
#define DMABUFFERLENGTH 128

//number of above DMA Buffers of DMABUFFERLENGTH
#define DMABUFFERCOUNT  8

  // processor timing variables for system monitor, also included in task.cpp
  extern unsigned int runningTicks;
  extern unsigned int usedticks;
  extern unsigned int availableticks;
  extern unsigned int availableticks_start;
  extern unsigned int availableticks_end;
  extern unsigned int usedticks_start;
  extern unsigned int usedticks_end;
  extern unsigned int processedframe;
  extern unsigned int audiofps;

 void I2S_init(void);

#endif