#include "set_module.h"
#include "set_settings.h"
#include "set_codec.h"

//controller_module myPedal definition
controller_module *myPedal = new controller_module();

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~ DSP Class Definitions (bsdsp files) ~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~ CONTROLLER MODULE CLASS DEFINITIONS ~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Define the controllerModule functions declared in set_module.h
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::init()  //effect module class initialization
 {
  name = "Transfer Function Distortion";

  // Set up pin Modes for the switches and LEDs
  // For mode details, see control_task() and button_task() in task.cpp
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(KEY1, INPUT_PULLUP);  //internal pullup
  pinMode(KEY2, INPUT_PULLUP);         
 
  //setting up the buttons
  button[0].name = "mute";
  button[0].mode = BM_MOMENTARY;
  button[0].touch = false;
  button[0].pin = KEY1;

  button[1].name = "LED";
  button[1].mode = BM_MOMENTARY;
  button[1].touch = false;
  button[1].pin = KEY2;

  //add gain control
  control[0].name = "Threshold";
  control[0].mode = CM_POT;
  control[0].levelCount = 256;
  control[0].pin = POT1;

  //add range control
  control[1].name = "Distortion";
  control[1].mode = CM_POT;
  control[1].levelCount = 256;
  control[1].pin = POT2;

  control[5].name = "Mix";
  control[5].mode = CM_POT;
  control[5].levelCount = 256;  
  control[5].pin = POT6;

  threshold = 1.0;
  distortion = 0;
  mix = 0;
 }
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onButtonChange(int buttonIndex)
{
  switch(buttonIndex)
  {
    case 0: //main button state has changed
    {
      if(button[0].value) //mute
      {
        //codec.analogBypass(false);
        codec.disableDacMute(); 
        digitalWrite(LED1, HIGH);
      }
      else //if effect is bypassed
      {
        //codec.analogBypass(true); 
        codec.enableDacMute(); 
        digitalWrite(LED1, LOW);
      }
      break;
    }
    case 1: //the button[1] state has changed
    {
      if(button[1].value) // enter distortion values on button press
      {
        digitalWrite(LED2, HIGH); 
      }
      else 
      {digitalWrite(LED2, LOW);}
      break;
    }
  }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onControlChange(int controlIndex)
{
  switch(controlIndex)
  {
    case 0: //Threshold start of Distortion
    {
      threshold = (float)control[0].value/255.0;  // 0 to 1
      break;
    }
    case 1:  //Distortion as Function Slope
    {
      distortion = -1.0 + (float)control[1].value/130.0 ; // -1 to +1
      break;
    }
    case 5: //Pan between input and distortion  // 0 to 1
    {
      mix = (float)control[5].value/255.0;
      break;
    }
 }
}

