#include <Arduino.h>
#include "set_settings.h"
#include "set_module.h"
#include "set_codec.h"
#include "task.h"
#include <SD.h>
#include "sd_play.h"

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~SETUP~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void setup() 
{
  Serial.begin(115200);
  while(!Serial);
  delay(3000);
      
  //~~~~~~~~~~~codec is initialized  See Codec.cpp~~~~~~~~~~~~~~~~~
  //~~~~i2c is initialized within codec.init() with initI2C()~~~~~~

        Wire.begin();
        Serial.println("Initialize Codec Codec ");
        codec.begin();
        codec_sets();
        Serial.println("Codec Init success!!");

  //~~~~~~I2S  See set_settings.cpp for I2S ~~~~~~~~~~~~~~~
  
        I2S_init();
  
  //~~~~~~~~~~~~~~Monitor (can be commented out)~~~~~~~~~~
       
        Serial.println("I2S/SD setup complete");
        runSystemMonitor();  //for testing only

} //Setup End


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~MAIN LOOP~~~~~~~~~~~~~~~~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void loop() 
{
    size_t readsize = 0;
    int16_t rxbuf[FRAMELENGTH], txbuf[FRAMELENGTH]; //128 L+R signed 16 bit samples 
    float rxl, rxr, txl, txr;  //left and right single samples, processed as floats
    float rx, tx;  //mono input-output samples, -1 to +1 floats
    float a, b;
    float phase;
    bool rx_negative; 
    float table_rate = 255.0/(float)SAMPLE_RATE;

    myPedal->init();
    taskSetup();

  while(1){   //signal processing loop

  setDebugVars(myPedal->threshold, myPedal->frequency, myPedal->depth, myPedal->mix);

  /*
   read 256 samples = FRAMELENGTH (128 Left+Right signed samples). It's also the size of buffers.
   read 2 bytes for each 16 bit (2 byte) sample (FRAMLENGTH*2)
   rxbuf[] and txbuf[] defined with signed 16 bit integers (int16_t) and of FRAMELENGTH size. 
 */
  //gather some input samples into receive buffer from the DMA memory,
  i2s_read(I2S_NUM_0, rxbuf, FRAMELENGTH*2, &readsize, 20);

      //a = myPedal->aa ;
        a = myPedal->threshold ;
  
  for (int i=0; i<(FRAMELENGTH); i+=2) {  //process samples one at a time from buffers
    
    rxl = (float) (rxbuf[i]) ;   //convert sample to float
    rxr = (float) (rxbuf[i+1]) ; 

    rx = (0.5 * rxl) + (0.5 * rxr);  // change to mono signal, 0 to +/- 32767 input sample

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~~~~~~~~~Distortion Processing~~~~~~~~~~~~~
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    // same transfer function performed on positive and negative signal peaks
  
    if(rx < 0) 
            { rx_negative = 1; rx = -rx; }   // Flip negative sample values
    else {rx_negative = 0;}

    if(rx > a) 
    {  
            phase = ( (rx - a)/(32767.0 - a)) * table_rate * myPedal->frequency ; 
            phase = (phase - (float)(int(phase))) * 255.0;  // fractional part * 255 wavetable size
            triangle.setPhase(0);
            tx = triangle.getOutput(phase)* myPedal->depth; // transfer function from Triangle wave
            tx = a + (32767.0 * tx);   
            if(tx>32767.0) {tx=32767.0;}  // 0 to 32767 output sample
    }        
    else { tx = rx; }  // No sample changes below threshold

    if(rx_negative) { rx = -rx;  tx = -tx; }  // Flip back negative sample values

    txl = ((1 - myPedal->mix) * rx) + (myPedal->mix * tx); //mix of input and distorted
    txr = txl;  // Output Mono

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    txbuf[i]   = ((int16_t) txl) ; //convert sample back to integer
    txbuf[i+1] = ((int16_t) txr) ;
  }
  // play processed receive buffer by loading transmit buffer into DMA memory
  i2s_write(I2S_NUM_0, txbuf, FRAMELENGTH*2, &readsize, 20);

} // End of while(1) loop
} // End of Main Loop