#include "set_module.h"
#include "set_settings.h"
#include "set_codec.h"

//controller_module myPedal definition
controller_module *myPedal = new controller_module();

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~ DSP Class Definitions (bsdsp files) ~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  fractionalDelay delay1;
  fractionalDelay delay2;
  bool x = delay1.init(260); //init for delay
  bool y = delay2.init(260); //init for delay

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~ CONTROLLER MODULE CLASS DEFINITIONS ~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Define the controllerModule functions declared in set_module.h
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::init()  //effect module class initialization
 {
  name = "Echo Reverb";

  // Set up pin Modes for the switches and LEDs
  // For mode details, see control_task() and button_task() in task.cpp
  pinMode(LED1, OUTPUT);
  pinMode(LED2, OUTPUT);
  pinMode(KEY1, INPUT_PULLUP);  //internal pullup
  pinMode(KEY2, INPUT_PULLUP);         
 
  //setting up the buttons
  button[0].name = "mute";
  button[0].mode = BM_MOMENTARY;
  button[0].touch = false;
  button[0].pin = KEY1;

  button[1].name = "Enter Delay";
  button[1].mode = BM_MOMENTARY;
  button[1].touch = false;
  button[1].pin = KEY2;

  //add gain control
  control[0].name = "DelayMix1";
  control[0].mode = CM_POT;
  control[0].levelCount = 128;
  control[0].pin = POT1;

  //add range control
  control[1].name = "DelayTime1";
  control[1].mode = CM_POT;
  control[1].levelCount = 256;
  control[1].pin = POT2;

  control[2].name = "DelayMix2";
  control[2].mode = CM_POT;
  control[2].levelCount = 128;
  control[2].pin = POT3;

  control[3].name = "DelayTime2";
  control[3].mode = CM_POT;
  control[3].levelCount = 256;  
  control[3].pin = POT4;

  control[5].name = "Feedback";
  control[5].mode = CM_POT;
  control[5].levelCount = 128;  
  control[5].pin = POT6;

  delay_mix1 = 0.5;
  delay_mix2 = 0.5;
  delay_time1 = 0;
  delay_time2 = 0;
  feedback = 0;
 }
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onButtonChange(int buttonIndex)
{
  switch(buttonIndex)
  {
    case 0: //main button state has changed
    {
      if(button[0].value) //if effect is activated
      {
        //codec.analogBypass(false);
        codec.disableDacMute(); 
        digitalWrite(LED1, HIGH);
      }
      else //if effect is bypassed
      {
        //codec.analogBypass(true); 
        codec.enableDacMute(); 
        digitalWrite(LED1, LOW);
      }
      break;
    }
    case 1: //the button[1] state has changed
    {
      if(button[1].value) // enter delay times on button press
      {digitalWrite(LED2, HIGH); dt1=delay_time1; dt2=delay_time2; }
      else 
      {digitalWrite(LED2, LOW);}
      break;
    }
  }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onControlChange(int controlIndex)
{
  switch(controlIndex)
  {
    case 0: //delay mix1
    {
      delay_mix1 = (float)control[0].value/127.0;
      break;
    }
    case 1:  //delay time1
    {
      delay_time1 = control[1].value ;
      break;
    }
    case 2:  //delay mix2
    {
      delay_mix2 = (float)control[2].value/127.0;
      break;
    }
    case 3:  //delay time2
    {
      delay_time2 = control[3].value ;
      break;
    }
    case 5: //delay mix1
    {
      feedback = (float)control[5].value/127.0;
      break;
    }
 }
}

