
#include "set_module.h"
#include "set_settings.h"
#include "set_codec.h"

//controller_module myPedal definition
controller_module *myPedal = new controller_module();

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//~~~~~~ CONTROLLER MODULE CLASS DEFINITIONS ~~~~~~
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Define the ControllerModule functions declared above
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::init()  //effect module class initialization
 {
  name = "SparkfunGain";
  inputMode = IM_LR;   // IM_LR or IM_LMIC

  // Set up pin Modes for the switches and LEDs
  // Some need pullup resistor.
  // Most have hardware pullup resistors. 
  pinMode(KEY1, INPUT_PULLUP); 
  pinMode(LED1, OUTPUT);

  //setting up the buttons
  button[0].name = "Mute";
  button[0].mode = BM_TOGGLE;
  button[0].touch = false;
  button[0].pin = KEY1;
 
  //add gain control
  control[0].name = "Gain";
  control[0].mode = CM_POT;
  control[0].levelCount = 128;
  control[0].pin = POT1;

  gain = 1.0;
  gainRange = 1.0;
  mute = false;
 }
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onButtonChange(int buttonIndex)
{
  switch(buttonIndex)
  {
    case 0: //"Mute" button state has changed
    {
      if(button[0].value) //if effect is activated
      {
        codec.disableDacMute(); 
        digitalWrite(LED1, HIGH);
        mute = true;
      }
      else //if effect is bypassed
      {
        codec.enableDacMute(); 
        digitalWrite(LED1, LOW);
        mute = false;
      }
      break;
    }

  }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void controller_module::onControlChange(int controlIndex)
{
  switch(controlIndex)
  {
    case 0:
    {
      gain = (float)control[0].value/127.0;
      break;
    }
  }
}
